/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.LinkedList;
import java.util.List;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetEntityMotionPacket;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.MinecartStep;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundMoveMinecartPacket;

public class MinecartEntity
extends Entity
implements Tickable {
    private static final int POS_ROT_LERP_TICKS = 3;
    private final List<MinecartStep> lerpSteps = new LinkedList<MinecartStep>();
    private final List<MinecartStep> currentLerpSteps = new LinkedList<MinecartStep>();
    private MinecartStep lastCompletedStep = new MinecartStep(Vector3d.ZERO, Vector3d.ZERO, 0.0f, 0.0f, 0.0f);
    private float currentStepsTotalWeight = 0.0f;
    private int lerpDelay = 0;
    private PartialStep cachedPartialStep;
    private int cachedStepDelay;
    private float cachedDelta;
    private Vector3f lerpPosition;
    private int steps;
    protected boolean dirtyYaw;
    protected boolean dirtyHeadYaw;
    protected boolean dirtyPitch;

    public MinecartEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setCustomBlock(IntEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityDataTypes.CUSTOM_DISPLAY, (byte)(entityMetadata.getPrimitiveValue() != 0 ? 1 : 0));
        this.dirtyMetadata.put(EntityDataTypes.DISPLAY_BLOCK_STATE, this.session.getBlockMappings().getBedrockBlock(entityMetadata.getPrimitiveValue()));
    }

    public void setCustomBlockOffset(IntEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityDataTypes.DISPLAY_OFFSET, entityMetadata.getPrimitiveValue());
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        if (this.session.isUsingExperimentalMinecartLogic()) {
            super.moveAbsolute(position, yaw, pitch, headYaw, isOnGround, teleported);
            return;
        }
        if (position.distanceSquared(this.position) < 4096.0f && position.distanceSquared(this.session.getPlayerEntity().position()) < 4096.0f) {
            this.dirtyHeadYaw = true;
            this.dirtyYaw = true;
            this.dirtyPitch = true;
            this.setYaw(yaw);
            this.setPitch(pitch);
            this.setHeadYaw(headYaw);
            this.setOnGround(isOnGround);
            this.lerpPosition = position;
            this.steps = 3;
        } else {
            super.moveAbsolute(position, yaw, pitch, headYaw, isOnGround, teleported);
        }
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        if (this.session.isUsingExperimentalMinecartLogic()) {
            super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
            return;
        }
        Vector3f javaPosition = this.position.down(this.definition.offset());
        if ((relX != 0.0 || relY != 0.0 || relZ != 0.0) && javaPosition.distanceSquared(this.session.getPlayerEntity().position()) < 4096.0f) {
            this.dirtyPitch = pitch != this.pitch;
            this.dirtyYaw = yaw != this.yaw;
            this.dirtyHeadYaw = headYaw != this.headYaw;
            this.setYaw(yaw);
            this.setPitch(pitch);
            this.setHeadYaw(headYaw);
            this.setOnGround(isOnGround);
            this.lerpPosition = Vector3f.from((double)((double)javaPosition.getX() + relX), (double)((double)javaPosition.getY() + relY), (double)((double)javaPosition.getZ() + relZ));
            this.steps = 3;
        } else {
            super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
        }
    }

    @Override
    public void tick() {
        if (!this.session.isUsingExperimentalMinecartLogic()) {
            if (this.steps <= 0) {
                return;
            }
            float time = 1.0f / (float)this.steps;
            float lerpXTotal = GenericMath.lerp((float)this.position.getX(), (float)this.lerpPosition.getX(), (float)time);
            float lerpYTotal = GenericMath.lerp((float)(this.position.getY() - this.definition.offset()), (float)this.lerpPosition.getY(), (float)time) + this.definition.offset();
            float lerpZTotal = GenericMath.lerp((float)this.position.getZ(), (float)this.lerpPosition.getZ(), (float)time);
            MoveEntityDeltaPacket moveEntityPacket = new MoveEntityDeltaPacket();
            if (this.onGround) {
                moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.ON_GROUND);
            }
            if (lerpXTotal != this.position.getX()) {
                moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_X);
            }
            if (lerpYTotal != this.position.getY()) {
                moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Y);
            }
            if (lerpZTotal != this.position.getZ()) {
                moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Z);
            }
            if (this.dirtyYaw) {
                moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
            }
            if (this.dirtyHeadYaw) {
                moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_HEAD_YAW);
            }
            if (this.dirtyPitch) {
                moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
            }
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.TELEPORTING);
            moveEntityPacket.setRuntimeEntityId(this.geyserId);
            moveEntityPacket.setX(lerpXTotal);
            moveEntityPacket.setY(lerpYTotal);
            moveEntityPacket.setZ(lerpZTotal);
            moveEntityPacket.setYaw(this.getYaw());
            moveEntityPacket.setPitch(this.getPitch());
            moveEntityPacket.setHeadYaw(this.getHeadYaw());
            this.dirtyHeadYaw = false;
            this.dirtyYaw = false;
            this.dirtyPitch = false;
            this.session.getQueuedImmediatelyPackets().add(moveEntityPacket);
            this.position = Vector3f.from((float)lerpXTotal, (float)lerpYTotal, (float)lerpZTotal);
            --this.steps;
            return;
        }
        --this.lerpDelay;
        if (this.lerpDelay <= 0) {
            this.updateCompletedStep();
            this.currentLerpSteps.clear();
            if (!this.lerpSteps.isEmpty()) {
                this.currentLerpSteps.addAll(this.lerpSteps);
                this.lerpSteps.clear();
                this.currentStepsTotalWeight = 0.0f;
                for (MinecartStep step : this.currentLerpSteps) {
                    this.currentStepsTotalWeight += step.weight();
                }
                int n = this.lerpDelay = this.currentStepsTotalWeight == 0.0f ? 0 : 3;
            }
        }
        if (this.isLerping()) {
            float delta = 1.0f;
            Vector3f position = this.getCurrentLerpPosition(delta).toFloat();
            Vector3f movement = this.getCurrentLerpMovement(delta).toFloat();
            this.setPosition(position);
            this.setMotion(movement);
            this.setYaw(180.0f - this.getCurrentLerpYaw(delta));
            this.setPitch(this.getCurrentLerpPitch(delta));
            MoveEntityDeltaPacket moveEntityPacket = new MoveEntityDeltaPacket();
            moveEntityPacket.setRuntimeEntityId(this.geyserId);
            moveEntityPacket.setX(position.getX());
            moveEntityPacket.setY(position.getY() + this.definition.offset());
            moveEntityPacket.setZ(position.getZ());
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_X);
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Y);
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Z);
            moveEntityPacket.setYaw(this.getYaw());
            moveEntityPacket.setPitch(this.getPitch());
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
            SetEntityMotionPacket entityMotionPacket = new SetEntityMotionPacket();
            entityMotionPacket.setRuntimeEntityId(this.geyserId);
            entityMotionPacket.setMotion(movement);
            this.session.getQueuedImmediatelyPackets().add(moveEntityPacket);
            this.session.getQueuedImmediatelyPackets().add(entityMotionPacket);
        }
    }

    public void handleMinecartMovePacket(ClientboundMoveMinecartPacket packet) {
        this.lerpSteps.addAll(packet.getLerpSteps());
    }

    private boolean isLerping() {
        return !this.currentLerpSteps.isEmpty();
    }

    private float getCurrentLerpPitch(float delta) {
        PartialStep partialStep = this.getCurrentLerpStep(delta);
        return MinecartEntity.lerpRotation(partialStep.delta, partialStep.previousStep.xRot(), partialStep.currentStep.xRot());
    }

    private float getCurrentLerpYaw(float delta) {
        PartialStep partialStep = this.getCurrentLerpStep(delta);
        return MinecartEntity.lerpRotation(partialStep.delta, partialStep.previousStep.yRot(), partialStep.currentStep.yRot());
    }

    private Vector3d getCurrentLerpPosition(float delta) {
        PartialStep partialStep = this.getCurrentLerpStep(delta);
        return MinecartEntity.lerp((double)partialStep.delta, partialStep.previousStep.position(), partialStep.currentStep.position());
    }

    private Vector3d getCurrentLerpMovement(float delta) {
        PartialStep partialStep = this.getCurrentLerpStep(delta);
        return MinecartEntity.lerp((double)partialStep.delta, partialStep.previousStep.movement(), partialStep.currentStep.movement());
    }

    private PartialStep getCurrentLerpStep(float delta) {
        if (this.cachedDelta != delta || this.lerpDelay != this.cachedStepDelay || this.cachedPartialStep == null) {
            int step;
            float g = ((float)(3 - this.lerpDelay) + delta) / 3.0f;
            float totalWeight = 0.0f;
            float stepDelta = 1.0f;
            boolean foundStep = false;
            for (step = 0; step < this.currentLerpSteps.size(); ++step) {
                float currentWeight = this.currentLerpSteps.get(step).weight();
                if (currentWeight <= 0.0f || !((double)(totalWeight += currentWeight) >= (double)this.currentStepsTotalWeight * (double)g)) continue;
                float h = totalWeight - currentWeight;
                stepDelta = (g * this.currentStepsTotalWeight - h) / currentWeight;
                foundStep = true;
                break;
            }
            if (!foundStep) {
                step = this.currentLerpSteps.size() - 1;
            }
            MinecartStep currentStep = this.currentLerpSteps.get(step);
            MinecartStep previousStep = step > 0 ? this.currentLerpSteps.get(step - 1) : this.lastCompletedStep;
            this.cachedPartialStep = new PartialStep(stepDelta, currentStep, previousStep);
            this.cachedStepDelay = this.lerpDelay;
            this.cachedDelta = delta;
        }
        return this.cachedPartialStep;
    }

    private void updateCompletedStep() {
        this.lastCompletedStep = new MinecartStep(this.position.toDouble(), this.motion.toDouble(), this.yaw, this.pitch, 0.0f);
    }

    @Override
    public void moveAbsoluteRaw(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsoluteRaw(position.up(this.definition.offset()), yaw, pitch, headYaw, isOnGround, teleported);
    }

    @Override
    public Vector3f getBedrockRotation() {
        return Vector3f.from((float)0.0f, (float)this.getYaw(), (float)0.0f);
    }

    @Override
    public boolean doesJumpDismount() {
        return false;
    }

    @Override
    protected InteractiveTag testInteraction(Hand hand) {
        if (this.definition == EntityDefinitions.CHEST_MINECART || this.definition == EntityDefinitions.HOPPER_MINECART) {
            return InteractiveTag.OPEN_CONTAINER;
        }
        if (this.session.isSneaking() || this.definition == EntityDefinitions.TNT_MINECART) {
            return InteractiveTag.NONE;
        }
        if (!this.passengers.isEmpty()) {
            return InteractiveTag.NONE;
        }
        return InteractiveTag.RIDE_MINECART;
    }

    @Override
    public InteractionResult interact(Hand hand) {
        if (this.definition == EntityDefinitions.CHEST_MINECART || this.definition == EntityDefinitions.HOPPER_MINECART) {
            return InteractionResult.SUCCESS;
        }
        if (this.session.isSneaking()) {
            return InteractionResult.PASS;
        }
        if (!this.passengers.isEmpty()) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private static Vector3d lerp(double delta, Vector3d start, Vector3d end) {
        return Vector3d.from((double)MinecartEntity.lerp(delta, start.getX(), end.getX()), (double)MinecartEntity.lerp(delta, start.getY(), end.getY()), (double)MinecartEntity.lerp(delta, start.getZ(), end.getZ()));
    }

    public static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    private static float lerpRotation(float delta, float start, float end) {
        return start + delta * MathUtils.wrapDegrees(end - start);
    }

    private record PartialStep(float delta, MinecartStep currentStep, MinecartStep previousStep) {
    }
}

