/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.concurrent.CompletableFuture;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.ThrowableEntity;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.AddItemEntityPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ItemEntity
extends ThrowableEntity {
    protected ItemData item;
    private CompletableFuture<Integer> waterLevel = CompletableFuture.completedFuture(-1);

    public ItemEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    public void spawnEntity() {
        if (this.item == null) {
            return;
        }
        this.valid = true;
        AddItemEntityPacket itemPacket = new AddItemEntityPacket();
        itemPacket.setRuntimeEntityId(this.geyserId);
        itemPacket.setUniqueEntityId(this.geyserId);
        itemPacket.setPosition(this.position.add(0.0, (double)this.definition.offset(), 0.0));
        itemPacket.setMotion(this.motion);
        itemPacket.setFromFishing(false);
        itemPacket.setItemInHand(this.item);
        itemPacket.getMetadata().putFlags(this.flags);
        this.dirtyMetadata.apply(itemPacket.getMetadata());
        this.setFlagsDirty(false);
        this.session.sendUpstreamPacket(itemPacket);
    }

    @Override
    public void tick() {
        if (this.removedInVoid() || this.isInWater()) {
            return;
        }
        if (!this.isOnGround() || (double)(this.motion.getX() * this.motion.getX() + this.motion.getZ() * this.motion.getZ()) > 1.0E-5) {
            float gravity = this.getGravity();
            this.motion = this.motion.down(gravity);
            this.moveAbsoluteImmediate(this.position.add(this.motion), this.getYaw(), this.getPitch(), this.getHeadYaw(), this.isOnGround(), false);
            float drag = this.getDrag();
            this.motion = this.motion.mul(drag, 0.98f, drag);
        }
    }

    public void setItem(EntityMetadata<ItemStack, ?> entityMetadata) {
        ItemData item = ItemTranslator.translateToBedrock(this.session, entityMetadata.getValue());
        if (this.item == null) {
            this.item = item;
            this.spawnEntity();
        } else if (item.equals(this.item, false, true, true)) {
            if (this.item.getCount() != item.getCount()) {
                this.item = item;
                EntityEventPacket packet = new EntityEventPacket();
                packet.setRuntimeEntityId(this.geyserId);
                packet.setType(EntityEventType.UPDATE_ITEM_STACK_SIZE);
                packet.setData(this.item.getCount());
                this.session.sendUpstreamPacket(packet);
            }
        } else {
            this.item = item;
            this.despawnEntity();
            this.spawnEntity();
        }
    }

    @Override
    protected void moveAbsoluteImmediate(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        float offset = this.definition.offset();
        if (this.waterLevel.join() == 0) {
            offset = -this.definition.offset();
        }
        super.moveAbsoluteImmediate(position.add(0.0f, offset, 0.0f), 0.0f, 0.0f, 0.0f, isOnGround, teleported);
        this.position = position;
        this.waterLevel = this.session.getGeyser().getWorldManager().getBlockAtAsync(this.session, position.getFloorX(), position.getFloorY(), position.getFloorZ()).thenApply(BlockStateValues::getWaterLevel);
    }

    @Override
    protected float getGravity() {
        if (this.getFlag(EntityFlag.HAS_GRAVITY) && !this.isOnGround() && !this.isInWater()) {
            return 0.04f;
        }
        return 0.0f;
    }

    @Override
    protected float getDrag() {
        if (this.isOnGround()) {
            Vector3i groundBlockPos = this.position.toInt().down(1);
            BlockState blockState = this.session.getGeyser().getWorldManager().blockAt(this.session, groundBlockPos);
            return BlockStateValues.getSlipperiness(blockState) * 0.98f;
        }
        return 0.98f;
    }

    @Override
    protected boolean isInWater() {
        return this.waterLevel.join() != -1;
    }
}

