/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.OptionalInt;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.MovementEffectType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.MovementEffectPacket;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class FireworkEntity
extends Entity {
    private boolean attachedToSession;

    public FireworkEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setFireworkItem(EntityMetadata<ItemStack, ?> entityMetadata) {
        ItemStack item = entityMetadata.getValue();
        if (item == null) {
            return;
        }
        DataComponents components = item.getDataComponentsPatch();
        if (components == null) {
            return;
        }
        BedrockItemBuilder builder = new BedrockItemBuilder();
        TooltipOptions tooltip = TooltipOptions.fromComponents(components);
        Items.FIREWORK_ROCKET.translateComponentsToBedrock(this.session, components, tooltip, builder);
        this.dirtyMetadata.put(EntityDataTypes.DISPLAY_FIREWORK, builder.build());
    }

    public void setPlayerGliding(EntityMetadata<OptionalInt, ?> entityMetadata) {
        this.session.getAttachedFireworkRockets().remove(this.geyserId);
        OptionalInt optional = entityMetadata.getValue();
        if (optional.isPresent() && optional.getAsInt() == this.session.getPlayerEntity().getEntityId()) {
            this.sendElytraBoost(1000000);
            this.attachedToSession = true;
            this.session.getAttachedFireworkRockets().add(this.geyserId());
        } else if (this.attachedToSession && this.session.getAttachedFireworkRockets().isEmpty()) {
            this.sendElytraBoost(0);
            this.attachedToSession = false;
        }
    }

    @Override
    public void despawnEntity() {
        this.session.getAttachedFireworkRockets().remove(this.geyserId);
        if (this.attachedToSession && this.session.getAttachedFireworkRockets().isEmpty()) {
            this.sendElytraBoost(0);
            this.attachedToSession = false;
        }
        super.despawnEntity();
    }

    private void sendElytraBoost(int duration) {
        MovementEffectPacket movementEffect = new MovementEffectPacket();
        movementEffect.setDuration(duration);
        movementEffect.setEffectType(MovementEffectType.GLIDE_BOOST);
        movementEffect.setEntityRuntimeId(this.session.getPlayerEntity().geyserId());
        movementEffect.setTick(this.session.getClientTicks());
        this.session.sendUpstreamPacket(movementEffect);
    }
}

