/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.spawn;

import java.util.UUID;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TriFunction;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundAddEntityPacket;

public class EntitySpawnContext {
    private final GeyserSession session;
    private final EntityDefinition<?> entityTypeDefinition;
    private int javaId;
    private final UUID uuid;
    private Vector3f position;
    private Vector3f motion;
    private float yaw;
    private float pitch;
    private float headYaw;
    private @Nullable Long geyserId;
    public static final TriFunction<GeyserSession, UUID, EntityDefinition<?>, EntitySpawnContext> DUMMY_CONTEXT = (session, uuid, definition) -> new EntitySpawnContext((GeyserSession)session, (EntityDefinition<?>)definition, -1, (UUID)uuid);

    public EntitySpawnContext(GeyserSession session, EntityDefinition<?> definition, int javaId, UUID uuid) {
        this(session, definition, javaId, uuid, Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, null);
    }

    public EntitySpawnContext(GeyserSession session, EntityDefinition<?> definition, int entityId, long geyserId) {
        this(session, definition, entityId, null, Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, geyserId);
    }

    public static EntitySpawnContext fromPacket(GeyserSession session, EntityDefinition<?> definition, ClientboundAddEntityPacket packet) {
        Vector3f position = Vector3f.from((double)packet.getX(), (double)packet.getY(), (double)packet.getZ());
        Vector3f motion = packet.getMovement().toFloat();
        return new EntitySpawnContext(session, definition, packet.getEntityId(), packet.getUuid(), position, motion, packet.getYaw(), packet.getPitch(), packet.getHeadYaw(), null);
    }

    public static EntitySpawnContext inherited(GeyserSession session, EntityDefinition<?> definition, Entity parent, Vector3f position) {
        return new EntitySpawnContext(session, definition, 0, null, position, parent.getMotion(), parent.getYaw(), parent.getPitch(), parent.getHeadYaw(), null);
    }

    public EntitySpawnContext(GeyserSession session, EntityDefinition<?> definition, int javaId, UUID uuid, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw, @Nullable Long geyserId) {
        this.session = session;
        this.entityTypeDefinition = definition;
        this.javaId = javaId;
        this.uuid = uuid;
        this.position = position.up(definition.offset());
        this.motion = motion;
        this.yaw = yaw;
        this.pitch = pitch;
        this.headYaw = headYaw;
        this.geyserId = geyserId;
    }

    public long geyserId() {
        if (this.geyserId == null) {
            this.geyserId = this.session.getEntityCache().getNextEntityId().incrementAndGet();
            return this.geyserId;
        }
        return this.geyserId;
    }

    @Generated
    public GeyserSession session() {
        return this.session;
    }

    @Generated
    public EntityDefinition<?> entityTypeDefinition() {
        return this.entityTypeDefinition;
    }

    @Generated
    public int javaId() {
        return this.javaId;
    }

    @Generated
    public UUID uuid() {
        return this.uuid;
    }

    @Generated
    public Vector3f position() {
        return this.position;
    }

    @Generated
    public Vector3f motion() {
        return this.motion;
    }

    @Generated
    public float yaw() {
        return this.yaw;
    }

    @Generated
    public float pitch() {
        return this.pitch;
    }

    @Generated
    public float headYaw() {
        return this.headYaw;
    }

    @Generated
    public EntitySpawnContext javaId(int javaId) {
        this.javaId = javaId;
        return this;
    }

    @Generated
    public EntitySpawnContext position(Vector3f position) {
        this.position = position;
        return this;
    }

    @Generated
    public EntitySpawnContext motion(Vector3f motion) {
        this.motion = motion;
        return this;
    }

    @Generated
    public EntitySpawnContext yaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    @Generated
    public EntitySpawnContext pitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    @Generated
    public EntitySpawnContext headYaw(float headYaw) {
        this.headYaw = headYaw;
        return this;
    }

    @Generated
    public EntitySpawnContext geyserId(@Nullable Long geyserId) {
        this.geyserId = geyserId;
        return this;
    }
}

