/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.util;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.GeyserApi;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface Identifier {
    public static final String DEFAULT_NAMESPACE = "minecraft";

    public static Identifier of(@NonNull String namespace, @NonNull String path) {
        return (Identifier)GeyserApi.api().provider(Identifier.class, namespace, path);
    }

    public static Identifier of(String identifier) {
        String path;
        String namespace;
        String[] split = identifier.split(":");
        if (split.length == 1) {
            namespace = DEFAULT_NAMESPACE;
            path = split[0];
        } else if (split.length == 2) {
            namespace = split[0];
            path = split[1];
        } else {
            throw new IllegalArgumentException("':' in identifier path: " + identifier);
        }
        return Identifier.of(namespace, path);
    }

    public String namespace();

    public String path();

    default public boolean vanilla() {
        return this.namespace().equals(DEFAULT_NAMESPACE);
    }
}

