/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    public static String prefix;

    private static String applyPrefix(String className) {
        return prefix + "." + className;
    }

    @Nullable
    public static Class<?> getPrefixedClass(String className) {
        return ReflectionUtils.getClass(ReflectionUtils.applyPrefix(className));
    }

    @Nullable
    public static Class<?> getPrefixedClassSilently(String className) {
        try {
            return Class.forName(ReflectionUtils.applyPrefix(className));
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    @Nullable
    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> Class<T> getCastedClass(String className) {
        return ReflectionUtils.getClass(className);
    }

    public static Class<?> getClassSilently(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    public static Class<?> getClassOrThrow(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static Class<?> getClassOrFallbackPrefixed(String className, String fallbackClassName) {
        return ReflectionUtils.getClassOrFallback(ReflectionUtils.applyPrefix(className), ReflectionUtils.applyPrefix(fallbackClassName));
    }

    public static Class<?> getClassOrFallback(String className, String fallbackClassName) {
        Class<?> clazz = ReflectionUtils.getClassSilently(className);
        if (clazz != null) {
            return clazz;
        }
        clazz = ReflectionUtils.getClassOrThrow(fallbackClassName);
        return clazz;
    }

    @Nullable
    public static <T> Constructor<T> getConstructor(Class<T> clazz, boolean declared, Class<?> ... parameters) {
        try {
            Constructor<T> constructor = declared ? clazz.getDeclaredConstructor(parameters) : clazz.getConstructor(parameters);
            ReflectionUtils.makeAccessible(constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static <T> T newInstance(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    @Nullable
    public static Field getField(Class<?> clazz, String fieldName, boolean declared) {
        try {
            if (declared) {
                return clazz.getField(fieldName);
            }
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
            return null;
        }
    }

    @Nullable
    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = ReflectionUtils.getField(clazz, fieldName, true);
        if (field != null) {
            return field;
        }
        return ReflectionUtils.getField(clazz, fieldName, false);
    }

    @Nullable
    public static Field getFieldOfType(Class<?> clazz, Class<?> fieldType, boolean declared) {
        Field[] fields;
        for (Field field : fields = declared ? clazz.getDeclaredFields() : clazz.getFields()) {
            ReflectionUtils.makeAccessible(field);
            if (field.getType() != fieldType) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static Field getFieldOfType(Class<?> clazz, Class<?> fieldType) {
        return ReflectionUtils.getFieldOfType(clazz, fieldType, true);
    }

    @Nullable
    public static Object getValue(Object instance, Field field) {
        ReflectionUtils.makeAccessible(field);
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean getBooleanValue(Object instance, Field field) {
        ReflectionUtils.makeAccessible(field);
        try {
            return field.getBoolean(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Nullable
    public static Object getValue(Object instance, String fieldName) {
        return ReflectionUtils.getValue(instance, ReflectionUtils.getField(instance.getClass(), fieldName));
    }

    @Nullable
    public static <T> T getCastedValue(Object instance, Field field) {
        return (T)ReflectionUtils.getValue(instance, field);
    }

    @Nullable
    public static <T> T getCastedValue(Object instance, String fieldName) {
        return (T)ReflectionUtils.getValue(instance, ReflectionUtils.getField(instance.getClass(), fieldName));
    }

    @Nullable
    public static <T> T castedStaticValue(Field field) {
        return ReflectionUtils.getCastedValue(null, field);
    }

    public static boolean castedStaticBooleanValue(Field field) {
        ReflectionUtils.makeAccessible(field);
        try {
            return field.getBoolean(null);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static void setValue(Object instance, Field field, Object value) {
        ReflectionUtils.makeAccessible(field);
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
    }

    public static boolean setValue(Object instance, String fieldName, Object value) {
        Field field = ReflectionUtils.getField(instance.getClass(), fieldName);
        if (field != null) {
            ReflectionUtils.setValue(instance, field, value);
        }
        return field != null;
    }

    @Nullable
    public static Method getMethod(Class<?> clazz, String method, boolean declared, Class<?> ... arguments) {
        try {
            if (declared) {
                return clazz.getMethod(method, arguments);
            }
            return clazz.getDeclaredMethod(method, arguments);
        }
        catch (NoSuchMethodException exception) {
            return null;
        }
    }

    @Nullable
    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... arguments) {
        Method method = ReflectionUtils.getMethod(clazz, methodName, true, arguments);
        if (method != null) {
            return method;
        }
        return ReflectionUtils.getMethod(clazz, methodName, false, arguments);
    }

    @Nullable
    public static Method getMethod(Object instance, String methodName, Class<?> ... arguments) {
        return ReflectionUtils.getMethod(instance.getClass(), methodName, arguments);
    }

    @Nullable
    public static Method getMethod(Class<?> clazz, Class<?> returnType, boolean declared, Class<?> ... parameterTypes) {
        Method[] methods;
        block0: for (Method method : methods = declared ? clazz.getDeclaredMethods() : clazz.getMethods()) {
            if (parameterTypes.length != method.getParameterCount() || !method.getReturnType().equals(returnType)) continue;
            Class<?>[] parameters = method.getParameterTypes();
            for (int i = 0; i < parameters.length; ++i) {
                if (!parameters[i].equals(parameterTypes[i])) continue block0;
            }
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getMethodByName(Class<?> clazz, String methodName, boolean declared) {
        Method[] methods;
        for (Method method : methods = declared ? clazz.getDeclaredMethods() : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getMethodFromParam(Class<?> clazz, Class<?> paramType, boolean declared) {
        Method[] methods;
        for (Method method : methods = declared ? clazz.getDeclaredMethods() : clazz.getMethods()) {
            for (Class<?> parameter : method.getParameterTypes()) {
                if (!parameter.equals(paramType)) continue;
                return method;
            }
        }
        return null;
    }

    @Nullable
    public static Object invoke(Object instance, Method method, Object ... arguments) {
        if (method == null) {
            return null;
        }
        ReflectionUtils.makeAccessible(method);
        try {
            return method.invoke(instance, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T cast(Object instance, Class<T> castTo) {
        if (castTo == null) {
            throw new IllegalArgumentException("Cannot cast instance to null");
        }
        return castTo.cast(instance);
    }

    @Nullable
    public static <T> T castedInvoke(Object instance, Method method, Object ... arguments) {
        return (T)ReflectionUtils.invoke(instance, method, arguments);
    }

    @Nullable
    public static <T> T castedInvoke(Object instance, String method) {
        return ReflectionUtils.castedInvoke(instance, ReflectionUtils.getMethod(instance.getClass(), method, new Class[0]), new Object[0]);
    }

    @Nullable
    public static Object invokeStatic(Class<?> clazz, String method) {
        return ReflectionUtils.invoke(null, ReflectionUtils.getMethod(clazz, method, new Class[0]), new Object[0]);
    }

    public static <T extends AccessibleObject> T makeAccessible(T accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    private ReflectionUtils() {
    }
}

