/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundGameTestHighlightPosPacket
implements MinecraftPacket {
    private final Vector3i absolutePos;
    private final Vector3i relativePos;

    public ClientboundGameTestHighlightPosPacket(ByteBuf in) {
        this.absolutePos = MinecraftTypes.readPosition(in);
        this.relativePos = MinecraftTypes.readPosition(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.absolutePos);
        MinecraftTypes.writePosition(out, this.relativePos);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Vector3i getAbsolutePos() {
        return this.absolutePos;
    }

    public Vector3i getRelativePos() {
        return this.relativePos;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundGameTestHighlightPosPacket)) {
            return false;
        }
        ClientboundGameTestHighlightPosPacket other = (ClientboundGameTestHighlightPosPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3i this$absolutePos = this.getAbsolutePos();
        Vector3i other$absolutePos = other.getAbsolutePos();
        if (this$absolutePos == null ? other$absolutePos != null : !this$absolutePos.equals(other$absolutePos)) {
            return false;
        }
        Vector3i this$relativePos = this.getRelativePos();
        Vector3i other$relativePos = other.getRelativePos();
        return !(this$relativePos == null ? other$relativePos != null : !this$relativePos.equals(other$relativePos));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundGameTestHighlightPosPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3i $absolutePos = this.getAbsolutePos();
        result = result * 59 + ($absolutePos == null ? 43 : $absolutePos.hashCode());
        Vector3i $relativePos = this.getRelativePos();
        result = result * 59 + ($relativePos == null ? 43 : $relativePos.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundGameTestHighlightPosPacket(absolutePos=" + String.valueOf(this.getAbsolutePos()) + ", relativePos=" + String.valueOf(this.getRelativePos()) + ")";
    }

    public @NonNull ClientboundGameTestHighlightPosPacket withAbsolutePos(Vector3i absolutePos) {
        return this.absolutePos == absolutePos ? this : new ClientboundGameTestHighlightPosPacket(absolutePos, this.relativePos);
    }

    public @NonNull ClientboundGameTestHighlightPosPacket withRelativePos(Vector3i relativePos) {
        return this.relativePos == relativePos ? this : new ClientboundGameTestHighlightPosPacket(this.absolutePos, relativePos);
    }

    public ClientboundGameTestHighlightPosPacket(Vector3i absolutePos, Vector3i relativePos) {
        this.absolutePos = absolutePos;
        this.relativePos = relativePos;
    }
}

