/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Function;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.util.FileUtils;

public class AnnotatedRegistryLoader<R, A extends Annotation, V>
implements RegistryLoader<String, Map<R, V>> {
    private final Class<A> annotation;
    private final Function<A, R> mapper;

    public AnnotatedRegistryLoader(Class<A> annotation, Function<A, R> mapper) {
        this.annotation = annotation;
        this.mapper = mapper;
    }

    @Override
    public Map<R, V> load(String input) {
        Object2ObjectOpenHashMap entries = new Object2ObjectOpenHashMap();
        for (Class<?> clazz : FileUtils.getGeneratedClassesForAnnotation(input)) {
            try {
                entries.put(this.mapper.apply(clazz.getAnnotation(this.annotation)), clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return entries;
    }
}

