/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord.shaded.org.spongepowered.configurate.serialize;

import java.lang.reflect.Type;
import java.util.Locale;
import java.util.function.Predicate;
import org.geysermc.geyser.platform.bungeecord.shaded.org.spongepowered.configurate.serialize.CoercionFailedException;
import org.geysermc.geyser.platform.bungeecord.shaded.org.spongepowered.configurate.serialize.ScalarSerializer;
import org.geysermc.geyser.platform.bungeecord.shaded.org.spongepowered.configurate.serialize.SerializationException;

final class BooleanSerializer
extends ScalarSerializer<Boolean> {
    BooleanSerializer() {
        super(Boolean.class);
    }

    @Override
    public Boolean deserialize(Type type, Object value) throws SerializationException {
        if (value instanceof Number) {
            return !value.equals(0);
        }
        String potential = value.toString().toLowerCase(Locale.ROOT);
        if (potential.equals("true") || potential.equals("t") || potential.equals("yes") || potential.equals("y") || potential.equals("1")) {
            return true;
        }
        if (potential.equals("false") || potential.equals("f") || potential.equals("no") || potential.equals("n") || potential.equals("0")) {
            return false;
        }
        throw new CoercionFailedException(type, value, "boolean");
    }

    @Override
    public Object serialize(Boolean item, Predicate<Class<?>> typeSupported) {
        if (typeSupported.test(Integer.class)) {
            return item != false ? 1 : 0;
        }
        return item.toString();
    }
}

