/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.plugin.Plugin;
import org.geysermc.geyser.dump.BootstrapDumpInfo;

public class GeyserBungeeDumpInfo
extends BootstrapDumpInfo {
    private final String platformName;
    private final String platformVersion;
    private final boolean onlineMode;
    private final List<BootstrapDumpInfo.ListenerInfo> listeners;
    private final List<BootstrapDumpInfo.PluginInfo> plugins;

    GeyserBungeeDumpInfo(ProxyServer proxy) {
        this.platformName = proxy.getName();
        this.platformVersion = proxy.getVersion();
        this.onlineMode = proxy.getConfig().isOnlineMode();
        this.listeners = new ArrayList<BootstrapDumpInfo.ListenerInfo>();
        this.plugins = new ArrayList<BootstrapDumpInfo.PluginInfo>();
        for (ListenerInfo listener : proxy.getConfig().getListeners()) {
            InetSocketAddress address = (InetSocketAddress)listener.getSocketAddress();
            this.listeners.add(new BootstrapDumpInfo.ListenerInfo(address.getHostString(), address.getPort()));
        }
        for (Plugin plugin : proxy.getPluginManager().getPlugins()) {
            this.plugins.add(new BootstrapDumpInfo.PluginInfo(true, plugin.getDescription().getName(), plugin.getDescription().getVersion(), plugin.getDescription().getMain(), Collections.singletonList(plugin.getDescription().getAuthor())));
        }
    }

    @Generated
    public String getPlatformName() {
        return this.platformName;
    }

    @Generated
    public String getPlatformVersion() {
        return this.platformVersion;
    }

    @Generated
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Generated
    public List<BootstrapDumpInfo.ListenerInfo> getListeners() {
        return this.listeners;
    }

    @Generated
    public List<BootstrapDumpInfo.PluginInfo> getPlugins() {
        return this.plugins;
    }
}

