/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.physics;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.CollisionResult;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.util.TriState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.OtherCollision;
import org.geysermc.geyser.translator.collision.ScaffoldingCollision;
import org.geysermc.geyser.translator.collision.SolidCollision;
import org.geysermc.geyser.util.BlockUtils;

public class CollisionManager {
    public static final BlockCollision SOLID_COLLISION = new SolidCollision(null);
    public static final BlockCollision FLUID_COLLISION = new OtherCollision(new BoundingBox[]{new BoundingBox(0.5, 0.25, 0.5, 1.0, 0.5, 1.0)});
    private final GeyserSession session;
    private final BoundingBox playerBoundingBox;
    private boolean touchingScaffolding;
    private boolean onScaffolding;
    public static final double COLLISION_TOLERANCE = 1.0E-5;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#####", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final double PLAYER_STEP_UP = 0.6;
    private static final double INCORRECT_MOVEMENT_THRESHOLD = 0.08;

    public CollisionManager(GeyserSession session) {
        this.session = session;
        this.playerBoundingBox = new BoundingBox(0.0, 0.0, 0.0, 0.6, 1.8, 0.6);
    }

    public void updatePlayerBoundingBox(Vector3f position) {
        this.updatePlayerBoundingBox(position.toDouble());
    }

    public void updatePlayerBoundingBox(Vector3d position) {
        this.updatePlayerBoundingBox();
        this.playerBoundingBox.setMiddleX(position.getX());
        this.playerBoundingBox.setMiddleY(position.getY() + this.playerBoundingBox.getSizeY() / 2.0);
        this.playerBoundingBox.setMiddleZ(position.getZ());
    }

    public void updatePlayerBoundingBox() {
        double playerHeight = this.session.getPlayerEntity().getBoundingBoxHeight();
        this.playerBoundingBox.setMiddleY(this.playerBoundingBox.getMiddleY() - this.playerBoundingBox.getSizeY() / 2.0 + playerHeight / 2.0);
        this.playerBoundingBox.setSizeY(playerHeight);
    }

    public BoundingBox getActiveBoundingBox() {
        ClientVehicle clientVehicle;
        Entity entity = this.session.getPlayerEntity().getVehicle();
        if (entity instanceof ClientVehicle && (clientVehicle = (ClientVehicle)((Object)entity)).isClientControlled()) {
            return clientVehicle.getVehicleComponent().getBoundingBox();
        }
        return this.playerBoundingBox;
    }

    public @Nullable CollisionResult adjustBedrockPosition(Vector3f bedrockPosition, boolean onGround, boolean teleported) {
        SessionPlayerEntity playerEntity;
        boolean newOnGround;
        ClientVehicle clientVehicle;
        PistonCache pistonCache = this.session.getPistonCache();
        if (pistonCache.isPlayerAttachedToHoney()) {
            return null;
        }
        double javaY = Double.parseDouble(Float.toString(bedrockPosition.getY())) - (double)EntityDefinitions.PLAYER.offset();
        Vector3d position = Vector3d.from(Double.parseDouble(Float.toString(bedrockPosition.getX())), javaY, Double.parseDouble(Float.toString(bedrockPosition.getZ())));
        Entity entity = this.session.getPlayerEntity().getVehicle();
        if (entity instanceof ClientVehicle && (clientVehicle = (ClientVehicle)((Object)entity)).isClientControlled()) {
            this.playerBoundingBox.setMiddleX(position.getX());
            this.playerBoundingBox.setMiddleY(position.getY() + this.playerBoundingBox.getSizeY() / 2.0);
            this.playerBoundingBox.setMiddleZ(position.getZ());
            return new CollisionResult(this.playerBoundingBox.getBottomCenter(), TriState.NOT_SET);
        }
        Vector3d startingPos = this.playerBoundingBox.getBottomCenter();
        Vector3d movement = position.sub(startingPos);
        Vector3d adjustedMovement = this.correctPlayerMovement(movement, false, teleported);
        this.playerBoundingBox.translate(adjustedMovement.getX(), adjustedMovement.getY(), adjustedMovement.getZ());
        this.playerBoundingBox.translate(pistonCache.getPlayerMotion().getX(), pistonCache.getPlayerMotion().getY(), pistonCache.getPlayerMotion().getZ());
        if (!this.correctPlayerPosition()) {
            this.recalculatePosition();
            return null;
        }
        if (pistonCache.isPlayerCollided()) {
            return null;
        }
        boolean bl = newOnGround = adjustedMovement.getY() != movement.getY() && movement.getY() < 0.0 || onGround;
        if ((onGround != newOnGround || movement.distanceSquared(adjustedMovement) > 0.08) && (playerEntity = this.session.getPlayerEntity()).getVehicle() == null && pistonCache.getPlayerMotion().equals(Vector3f.ZERO) && !pistonCache.isPlayerSlimeCollision()) {
            this.recalculatePosition();
            return null;
        }
        position = this.playerBoundingBox.getBottomCenter();
        if (!newOnGround) {
            position = Vector3d.from(position.getX(), Double.parseDouble(DECIMAL_FORMAT.format(position.getY())), position.getZ());
        }
        return new CollisionResult(position, TriState.byBoolean(onGround));
    }

    public void recalculatePosition() {
        SessionPlayerEntity entity = this.session.getPlayerEntity();
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(entity.getGeyserId());
        movePlayerPacket.setPosition(entity.getPosition());
        movePlayerPacket.setRotation(entity.getBedrockRotation());
        movePlayerPacket.setMode(MovePlayerPacket.Mode.NORMAL);
        this.session.sendUpstreamPacket(movePlayerPacket);
    }

    public BlockPositionIterator collidableBlocksIterator(BoundingBox box) {
        Vector3d position = Vector3d.from(box.getMiddleX(), box.getMiddleY() - box.getSizeY() / 2.0, box.getMiddleZ());
        double pistonExpand = this.session.getPistonCache().getPistons().isEmpty() ? 0.0 : 1.0;
        int minCollisionX = (int)Math.floor(position.getX() - (box.getSizeX() / 2.0 + 1.0E-5 + pistonExpand));
        int maxCollisionX = (int)Math.floor(position.getX() + box.getSizeX() / 2.0 + 1.0E-5 + pistonExpand);
        int minCollisionY = (int)Math.floor(position.getY() - 0.5 - 1.0E-5 - pistonExpand / 2.0);
        int maxCollisionY = (int)Math.floor(position.getY() + box.getSizeY() + pistonExpand);
        int minCollisionZ = (int)Math.floor(position.getZ() - (box.getSizeZ() / 2.0 + 1.0E-5 + pistonExpand));
        int maxCollisionZ = (int)Math.floor(position.getZ() + box.getSizeZ() / 2.0 + 1.0E-5 + pistonExpand);
        return BlockPositionIterator.fromMinMax(minCollisionX, minCollisionY, minCollisionZ, maxCollisionX, maxCollisionY, maxCollisionZ);
    }

    public BlockPositionIterator playerCollidableBlocksIterator() {
        return this.collidableBlocksIterator(this.playerBoundingBox);
    }

    public boolean correctPlayerPosition() {
        this.touchingScaffolding = false;
        this.onScaffolding = false;
        BlockPositionIterator iter = this.session.getCollisionManager().playerCollidableBlocksIterator();
        int[] blocks = this.session.getGeyser().getWorldManager().getBlocksAt(this.session, iter);
        iter.reset();
        while (iter.hasNext()) {
            BlockCollision blockCollision = BlockUtils.getCollision(blocks[iter.getIteration()]);
            if (blockCollision != null) {
                blockCollision.beforeCorrectPosition(iter.getX(), iter.getY(), iter.getZ(), this.playerBoundingBox);
            }
            iter.next();
        }
        iter.reset();
        while (iter.hasNext()) {
            BlockCollision blockCollision;
            int blockId = blocks[iter.getIteration()];
            if (!this.session.getBlockMappings().getCollisionIgnoredBlocks().contains(blockId) && (blockCollision = BlockUtils.getCollision(blockId)) != null && !blockCollision.correctPosition(this.session, iter.getX(), iter.getY(), iter.getZ(), this.playerBoundingBox)) {
                return false;
            }
            iter.next();
        }
        this.updateScaffoldingFlags(true);
        return true;
    }

    public Vector3d correctPlayerMovement(Vector3d movement, boolean checkWorld, boolean teleported) {
        if (teleported || !checkWorld && this.session.getPistonCache().getPistons().isEmpty()) {
            return movement;
        }
        return this.correctMovement(movement, this.playerBoundingBox, this.session.getPlayerEntity().isOnGround(), 0.6, checkWorld, false);
    }

    public Vector3d correctMovement(Vector3d movement, BoundingBox boundingBox, boolean onGround, double stepUp, boolean checkWorld, boolean walkOnLava) {
        Vector3d adjustedMovement = movement;
        if (!movement.equals(Vector3d.ZERO)) {
            adjustedMovement = this.correctMovementForCollisions(movement, boundingBox, checkWorld, walkOnLava);
        }
        boolean verticalCollision = adjustedMovement.getY() != movement.getY();
        boolean horizontalCollision = adjustedMovement.getX() != movement.getX() || adjustedMovement.getZ() != movement.getZ();
        boolean falling = movement.getY() < 0.0;
        boolean bl = onGround = onGround || verticalCollision && falling;
        if (onGround && horizontalCollision) {
            BoundingBox stepUpBoundingBox;
            Vector3d horizontalMovement = Vector3d.from(movement.getX(), 0.0, movement.getZ());
            Vector3d stepUpMovement = this.correctMovementForCollisions(horizontalMovement.up(stepUp), boundingBox, checkWorld, walkOnLava);
            BoundingBox stretchedBoundingBox = boundingBox.clone();
            stretchedBoundingBox.extend(horizontalMovement);
            double maxStepUp = this.correctMovementForCollisions(Vector3d.from(0.0, stepUp, 0.0), stretchedBoundingBox, checkWorld, walkOnLava).getY();
            if (maxStepUp < stepUp) {
                stepUpBoundingBox = boundingBox.clone();
                stepUpBoundingBox.translate(0.0, maxStepUp, 0.0);
                Vector3d adjustedStepUpMovement = this.correctMovementForCollisions(horizontalMovement, stepUpBoundingBox, checkWorld, walkOnLava);
                if (this.squaredHorizontalLength(adjustedStepUpMovement) > this.squaredHorizontalLength(stepUpMovement)) {
                    stepUpMovement = adjustedStepUpMovement.up(maxStepUp);
                }
            }
            if (this.squaredHorizontalLength(stepUpMovement) > this.squaredHorizontalLength(adjustedMovement)) {
                stepUpBoundingBox = boundingBox.clone();
                stepUpBoundingBox.translate(stepUpMovement.getX(), stepUpMovement.getY(), stepUpMovement.getZ());
                double verticalMovement = this.correctMovementForCollisions(Vector3d.from(0.0, movement.getY() - stepUpMovement.getY(), 0.0), stepUpBoundingBox, checkWorld, walkOnLava).getY();
                adjustedMovement = stepUpMovement = stepUpMovement.up(verticalMovement);
            }
        }
        return adjustedMovement;
    }

    private double squaredHorizontalLength(Vector3d vector) {
        return vector.getX() * vector.getX() + vector.getZ() * vector.getZ();
    }

    public Vector3d correctMovementForCollisions(Vector3d movement, BoundingBox boundingBox, boolean checkWorld, boolean walkOnLava) {
        boolean checkZFirst;
        double movementX = movement.getX();
        double movementY = movement.getY();
        double movementZ = movement.getZ();
        double originalX = boundingBox.getMiddleX();
        double originalY = boundingBox.getMiddleY();
        double originalZ = boundingBox.getMiddleZ();
        BoundingBox movementBoundingBox = boundingBox.clone();
        movementBoundingBox.extend(movement);
        BlockPositionIterator iter = this.collidableBlocksIterator(movementBoundingBox);
        if (Math.abs(movementY) > 1.0E-5) {
            movementY = this.computeCollisionOffset(boundingBox, Axis.Y, movementY, iter, checkWorld, walkOnLava);
            boundingBox.translate(0.0, movementY, 0.0);
        }
        boolean bl = checkZFirst = Math.abs(movementZ) > Math.abs(movementX);
        if (checkZFirst && Math.abs(movementZ) > 1.0E-5) {
            movementZ = this.computeCollisionOffset(boundingBox, Axis.Z, movementZ, iter, checkWorld, walkOnLava);
            boundingBox.translate(0.0, 0.0, movementZ);
        }
        if (Math.abs(movementX) > 1.0E-5) {
            movementX = this.computeCollisionOffset(boundingBox, Axis.X, movementX, iter, checkWorld, walkOnLava);
            boundingBox.translate(movementX, 0.0, 0.0);
        }
        if (!checkZFirst && Math.abs(movementZ) > 1.0E-5) {
            movementZ = this.computeCollisionOffset(boundingBox, Axis.Z, movementZ, iter, checkWorld, walkOnLava);
            boundingBox.translate(0.0, 0.0, movementZ);
        }
        boundingBox.setMiddleX(originalX);
        boundingBox.setMiddleY(originalY);
        boundingBox.setMiddleZ(originalZ);
        return Vector3d.from(movementX, movementY, movementZ);
    }

    private double computeCollisionOffset(BoundingBox boundingBox, Axis axis, double offset, BlockPositionIterator iter, boolean checkWorld, boolean walkOnLava) {
        iter.reset();
        while (iter.hasNext()) {
            int x = iter.getX();
            int y = iter.getY();
            int z = iter.getZ();
            if (checkWorld) {
                BlockCollision blockCollision;
                int blockId = this.session.getGeyser().getWorldManager().getBlockAt(this.session, x, y, z);
                BlockCollision blockCollision2 = blockCollision = walkOnLava ? this.getCollisionLavaWalking(blockId, y, boundingBox) : BlockUtils.getCollision(blockId);
                if (blockCollision != null && !(blockCollision instanceof ScaffoldingCollision)) {
                    offset = blockCollision.computeCollisionOffset(x, y, z, boundingBox, axis, offset);
                }
            }
            if (Math.abs(offset = this.session.getPistonCache().computeCollisionOffset(Vector3i.from(x, y, z), boundingBox, axis, offset)) < 1.0E-5) {
                return 0.0;
            }
            iter.next();
        }
        return offset;
    }

    public BlockCollision getCollisionLavaWalking(int blockId, int blockY, BoundingBox boundingBox) {
        if (BlockStateValues.getLavaLevel(blockId) == 0 && FLUID_COLLISION.isBelow(blockY, boundingBox)) {
            return FLUID_COLLISION;
        }
        return BlockUtils.getCollision(blockId);
    }

    public boolean isPlayerInWater() {
        BlockState state = this.session.getGeyser().getWorldManager().blockAt(this.session, this.session.getPlayerEntity().getPosition().toInt());
        return state.is(Blocks.WATER) && state.getValue(Properties.LEVEL) == 0;
    }

    public boolean isPlayerTouchingWater() {
        BlockState state = this.session.getGeyser().getWorldManager().blockAt(this.session, this.session.getPlayerEntity().position().toInt());
        return state.is(Blocks.WATER);
    }

    public boolean isWaterInEyes() {
        double eyeX = this.playerBoundingBox.getMiddleX();
        double eyeY = this.playerBoundingBox.getMiddleY() - this.playerBoundingBox.getSizeY() / 2.0 + (double)this.session.getEyeHeight();
        double eyeZ = this.playerBoundingBox.getMiddleZ();
        int blockID = this.session.getGeyser().getWorldManager().getBlockAt(this.session, GenericMath.floor(eyeX), GenericMath.floor(eyeY -= 0.1111111111111111), GenericMath.floor(eyeZ));
        double waterHeight = BlockStateValues.getWaterHeight(blockID);
        return waterHeight != -1.0 && eyeY < Math.floor(eyeY) + waterHeight;
    }

    public void updateScaffoldingFlags(boolean updateMetadata) {
        SessionPlayerEntity entity = this.session.getPlayerEntity();
        entity.setInsideScaffolding(this.touchingScaffolding);
        boolean isSneakingWithScaffolding = (this.touchingScaffolding || this.onScaffolding) && this.session.isSneaking();
        entity.setFlag(EntityFlag.OVER_DESCENDABLE_BLOCK, this.onScaffolding);
        entity.setFlag(EntityFlag.IN_ASCENDABLE_BLOCK, this.touchingScaffolding);
        entity.setFlag(EntityFlag.OVER_SCAFFOLDING, isSneakingWithScaffolding);
        entity.setFlag(EntityFlag.IN_SCAFFOLDING, this.touchingScaffolding);
        if (updateMetadata) {
            this.session.getPlayerEntity().updateBedrockMetadata();
        }
    }

    @Generated
    public BoundingBox getPlayerBoundingBox() {
        return this.playerBoundingBox;
    }

    @Generated
    public void setTouchingScaffolding(boolean touchingScaffolding) {
        this.touchingScaffolding = touchingScaffolding;
    }

    @Generated
    public void setOnScaffolding(boolean onScaffolding) {
        this.onScaffolding = onScaffolding;
    }
}

