/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Collections;
import java.util.Locale;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;

public enum Potion {
    WATER(0, 1),
    MUNDANE(1, 1),
    THICK(3, 1),
    AWKWARD(4, 1),
    NIGHT_VISION(5, 0x1F1FA1),
    LONG_NIGHT_VISION(6, 0x1F1FA1),
    INVISIBILITY(7, 8356754),
    LONG_INVISIBILITY(8, 8356754),
    LEAPING(9, 2293580),
    LONG_LEAPING(10, 2293580),
    STRONG_LEAPING(11, 2293580),
    FIRE_RESISTANCE(12, 14981690),
    LONG_FIRE_RESISTANCE(13, 14981690),
    SWIFTNESS(14, 8171462),
    LONG_SWIFTNESS(15, 8171462),
    STRONG_SWIFTNESS(16, 8171462),
    SLOWNESS(17, 5926017),
    LONG_SLOWNESS(18, 5926017),
    STRONG_SLOWNESS(42, 5926017),
    TURTLE_MASTER(37, 7691106),
    LONG_TURTLE_MASTER(38, 7691106),
    STRONG_TURTLE_MASTER(39, 7691106),
    WATER_BREATHING(19, 3035801),
    LONG_WATER_BREATHING(20, 3035801),
    HEALING(21, 16262179),
    STRONG_HEALING(22, 16262179),
    HARMING(23, 4393481),
    STRONG_HARMING(24, 4393481),
    POISON(25, 5149489),
    LONG_POISON(26, 5149489),
    STRONG_POISON(27, 5149489),
    REGENERATION(28, 13458603),
    LONG_REGENERATION(29, 13458603),
    STRONG_REGENERATION(30, 13458603),
    STRENGTH(31, 9643043),
    LONG_STRENGTH(32, 9643043),
    STRONG_STRENGTH(33, 9643043),
    WEAKNESS(34, 0x484D48),
    LONG_WEAKNESS(35, 0x484D48),
    LUCK(2, 1),
    SLOW_FALLING(40, 16773073),
    LONG_SLOW_FALLING(41, 16773073),
    WIND_CHARGING(43, 12438015),
    WEAVING(44, 7891290),
    OOZING(45, 10092451),
    INFESTATION(46, 9214860);

    public static final Potion[] VALUES;
    private final String javaIdentifier = "minecraft:" + this.name().toLowerCase(Locale.ENGLISH);
    private final short bedrockId;
    private final int javaColor;

    private Potion(int bedrockId, int javaColor) {
        this.bedrockId = (short)bedrockId;
        this.javaColor = javaColor;
    }

    public int tippedArrowId() {
        return this.bedrockId + 1;
    }

    public PotionContents toComponent() {
        return new PotionContents(this.ordinal(), -1, Collections.emptyList(), null);
    }

    public static Potion getByJavaIdentifier(String javaIdentifier) {
        for (Potion potion : VALUES) {
            if (!potion.javaIdentifier.equals(javaIdentifier)) continue;
            return potion;
        }
        return null;
    }

    public static @Nullable Potion getByJavaId(int javaId) {
        if (javaId >= 0 && javaId < VALUES.length) {
            return VALUES[javaId];
        }
        return null;
    }

    public static @Nullable Potion getByBedrockId(int bedrockId) {
        for (Potion potion : VALUES) {
            if (potion.bedrockId != bedrockId) continue;
            return potion;
        }
        return null;
    }

    public static @Nullable Potion getByTippedArrowDamage(int bedrockId) {
        return Potion.getByBedrockId(bedrockId - 1);
    }

    public static byte toTippedArrowId(int javaParticleColor) {
        for (Potion potion : VALUES) {
            if (potion.javaColor != javaParticleColor) continue;
            return (byte)(potion.bedrockId + 1);
        }
        return 0;
    }

    @Generated
    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    @Generated
    public short getBedrockId() {
        return this.bedrockId;
    }

    @Generated
    public int getJavaColor() {
        return this.javaColor;
    }

    static {
        VALUES = Potion.values();
    }

    private static final class ArrowParticleColors {
        static final int NONE = 1;
        static final int NIGHT_VISION = 0x1F1FA1;
        static final int INVISIBILITY = 8356754;
        static final int LEAPING = 2293580;
        static final int FIRE_RESISTANCE = 14981690;
        static final int SWIFTNESS = 8171462;
        static final int SLOWNESS = 5926017;
        static final int TURTLE_MASTER = 7691106;
        static final int WATER_BREATHING = 3035801;
        static final int HEALING = 16262179;
        static final int HARMING = 4393481;
        static final int POISON = 5149489;
        static final int REGENERATION = 13458603;
        static final int STRENGTH = 9643043;
        static final int WEAKNESS = 0x484D48;
        static final int LUCK = 0x339900;
        static final int SLOW_FALLING = 16773073;
        static final int WIND_CHARGING = 12438015;
        static final int WEAVING = 7891290;
        static final int OOZING = 10092451;
        static final int INFESTATION = 9214860;

        private ArrowParticleColors() {
        }
    }
}

