/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Leashable;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.vehicle.BoatVehicleComponent;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundPaddleBoatPacket;

public class BoatEntity
extends Entity
implements Tickable,
Leashable,
ClientVehicle {
    private static final String BUOYANCY_DATA = "{\"apply_gravity\":true,\"base_buoyancy\":1.0,\"big_wave_probability\":0.02999999932944775,\"big_wave_speed\":10.0,\"drag_down_on_buoyancy_removed\":0.0,\"liquid_blocks\":[\"minecraft:water\",\"minecraft:flowing_water\"],\"simulate_waves\":false}";
    private final BoatVehicleComponent vehicleComponent = new BoatVehicleComponent(this, 0.0f);
    private boolean isPaddlingLeft;
    private float paddleTimeLeft;
    private boolean isPaddlingRight;
    private float paddleTimeRight;
    private boolean doTick;
    protected final BoatVariant variant;
    private long leashHolderBedrockId = -1L;
    private final float ROWING_SPEED = 0.04f;

    public BoatEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, BoatVariant variant) {
        super(session, entityId, geyserId, uuid, definition, position.add(0.0, (double)definition.offset(), 0.0), motion, yaw + 90.0f, 0.0f, yaw + 90.0f);
        this.variant = variant;
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, variant.ordinal());
        this.dirtyMetadata.put(EntityDataTypes.IS_BUOYANT, true);
        this.dirtyMetadata.put(EntityDataTypes.BUOYANCY_DATA, BUOYANCY_DATA);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setFlag(EntityFlag.COLLIDABLE, true);
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.setPosition(position.add(0.0, (double)this.definition.offset(), 0.0));
        this.setYaw(yaw + 90.0f);
        this.setHeadYaw(yaw + 90.0f);
        this.setOnGround(isOnGround);
        MoveEntityAbsolutePacket moveEntityPacket = new MoveEntityAbsolutePacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        if (this.session.getPlayerEntity().getVehicle() == this && this.session.getPlayerEntity().isRidingInFront()) {
            moveEntityPacket.setPosition(position.up(EntityDefinitions.PLAYER.offset() - this.definition.offset()));
        } else {
            moveEntityPacket.setPosition(this.position);
        }
        moveEntityPacket.setRotation(this.getBedrockRotation());
        moveEntityPacket.setOnGround(isOnGround);
        moveEntityPacket.setTeleported(teleported);
        this.session.sendUpstreamPacket(moveEntityPacket);
    }

    public void moveAbsoluteWithoutAdjustments(Vector3f position, float yaw, boolean isOnGround, boolean teleported) {
        super.moveAbsolute(position, yaw, 0.0f, yaw, isOnGround, teleported);
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        super.moveRelative(relX, relY, relZ, yaw, 0.0f, yaw, isOnGround);
    }

    @Override
    public void updatePositionAndRotation(double moveX, double moveY, double moveZ, float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(moveX, moveY, moveZ, yaw + 90.0f, pitch, isOnGround);
    }

    @Override
    public void updateRotation(float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(0.0, 0.0, 0.0, yaw + 90.0f, 0.0f, 0.0f, isOnGround);
    }

    public void setPaddlingLeft(BooleanEntityMetadata entityMetadata) {
        this.isPaddlingLeft = entityMetadata.getPrimitiveValue();
        if (!this.isPaddlingLeft) {
            this.paddleTimeLeft = 0.0f;
            this.dirtyMetadata.put(EntityDataTypes.ROW_TIME_LEFT, Float.valueOf(0.0f));
        }
    }

    public void setPaddlingRight(BooleanEntityMetadata entityMetadata) {
        this.isPaddlingRight = entityMetadata.getPrimitiveValue();
        if (!this.isPaddlingRight) {
            this.paddleTimeRight = 0.0f;
            this.dirtyMetadata.put(EntityDataTypes.ROW_TIME_RIGHT, Float.valueOf(0.0f));
        }
    }

    @Override
    public void setLeashHolderBedrockId(long bedrockId) {
        this.leashHolderBedrockId = bedrockId;
        this.dirtyMetadata.put(EntityDataTypes.LEASH_HOLDER, bedrockId);
    }

    @Override
    protected InteractiveTag testInteraction(Hand hand) {
        InteractiveTag tag = super.testInteraction(hand);
        if (tag != InteractiveTag.NONE) {
            return tag;
        }
        if (this.session.isSneaking()) {
            return InteractiveTag.NONE;
        }
        if (this.passengers.size() < 2) {
            return InteractiveTag.BOARD_BOAT;
        }
        return InteractiveTag.NONE;
    }

    @Override
    public InteractionResult interact(Hand hand) {
        InteractionResult result = super.interact(hand);
        if (result != InteractionResult.PASS) {
            return result;
        }
        if (this.session.isSneaking()) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void tick() {
        if (this.session.getPlayerEntity().getVehicle() == this) {
            ServerboundPaddleBoatPacket steerPacket = new ServerboundPaddleBoatPacket(this.session.isSteeringLeft(), this.session.isSteeringRight());
            this.session.sendDownstreamGamePacket(steerPacket);
            if (this.session.isInClientPredictedVehicle()) {
                return;
            }
        }
        boolean bl = this.doTick = !this.doTick;
        if (!this.doTick || this.passengers.isEmpty()) {
            return;
        }
        Entity rower = (Entity)this.passengers.get(0);
        if (rower == null) {
            return;
        }
        if (this.isPaddlingLeft) {
            this.paddleTimeLeft += 0.04f;
            this.dirtyMetadata.put(EntityDataTypes.ROW_TIME_LEFT, Float.valueOf(this.paddleTimeLeft));
        }
        if (this.isPaddlingRight) {
            this.paddleTimeRight += 0.04f;
            this.dirtyMetadata.put(EntityDataTypes.ROW_TIME_RIGHT, Float.valueOf(this.paddleTimeRight));
        }
        if (this.isPaddlingLeft || this.isPaddlingRight) {
            this.updateBedrockMetadata();
        }
    }

    @Override
    public long leashHolderBedrockId() {
        return this.leashHolderBedrockId;
    }

    @Override
    public VehicleComponent<?> getVehicleComponent() {
        return this.vehicleComponent;
    }

    @Override
    public Vector3f getRiddenInput(Vector2f input) {
        return Vector3f.ZERO;
    }

    @Override
    public float getVehicleSpeed() {
        return 0.0f;
    }

    @Override
    public boolean isClientControlled() {
        return !this.session.isInClientPredictedVehicle() && !this.passengers.isEmpty() && this.session.getPlayerEntity() == this.passengers.get(0);
    }

    @Generated
    public BoatVariant getVariant() {
        return this.variant;
    }

    public static enum BoatVariant {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        MANGROVE,
        BAMBOO,
        CHERRY,
        PALE_OAK;

    }
}

