/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.components;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.item.custom.v2.component.java.ItemDataComponents;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.registry.mappings.components.DataComponentReader;
import org.geysermc.geyser.registry.mappings.components.readers.BooleanComponentReader;
import org.geysermc.geyser.registry.mappings.components.readers.ConsumableReader;
import org.geysermc.geyser.registry.mappings.components.readers.EnchantableReader;
import org.geysermc.geyser.registry.mappings.components.readers.EquippableReader;
import org.geysermc.geyser.registry.mappings.components.readers.FoodPropertiesReader;
import org.geysermc.geyser.registry.mappings.components.readers.IntComponentReader;
import org.geysermc.geyser.registry.mappings.components.readers.RepairableReader;
import org.geysermc.geyser.registry.mappings.components.readers.ToolPropertiesReader;
import org.geysermc.geyser.registry.mappings.components.readers.UseCooldownReader;
import org.geysermc.geyser.util.MinecraftKey;

public class DataComponentReaders {
    private static final Map<Key, DataComponentReader<?>> READERS = new HashMap();

    public static void readDataComponent(CustomItemDefinition.Builder builder, String key, @NonNull JsonElement element, String baseContext) throws InvalidCustomMappingsFileException {
        if (key.startsWith("!")) {
            builder.removeComponent(Identifier.of(key.substring(1)));
            return;
        }
        DataComponentReader<?> reader = READERS.get(MinecraftKey.key(key));
        if (reader == null) {
            throw new InvalidCustomMappingsFileException("reading data components", "unknown data component " + key, baseContext);
        }
        reader.read(builder, element, "component " + key, baseContext);
    }

    static {
        READERS.put(MinecraftKey.key("consumable"), new ConsumableReader());
        READERS.put(MinecraftKey.key("equippable"), new EquippableReader());
        READERS.put(MinecraftKey.key("food"), new FoodPropertiesReader());
        READERS.put(MinecraftKey.key("max_damage"), new IntComponentReader(ItemDataComponents.MAX_DAMAGE, 0));
        READERS.put(MinecraftKey.key("max_stack_size"), new IntComponentReader(ItemDataComponents.MAX_STACK_SIZE, 1, 99));
        READERS.put(MinecraftKey.key("use_cooldown"), new UseCooldownReader());
        READERS.put(MinecraftKey.key("enchantable"), new EnchantableReader());
        READERS.put(MinecraftKey.key("tool"), new ToolPropertiesReader());
        READERS.put(MinecraftKey.key("repairable"), new RepairableReader());
        READERS.put(MinecraftKey.key("enchantment_glint_override"), new BooleanComponentReader(ItemDataComponents.ENCHANTMENT_GLINT_OVERRIDE));
    }
}

