/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl;

import org.checkerframework.checker.index.qual.NonNegative;
import org.geysermc.geyser.api.item.custom.v2.component.java.FoodProperties;

public record FoodPropertiesImpl(int nutrition, float saturation, boolean canAlwaysEat) implements FoodProperties
{

    public static class Builder
    implements FoodProperties.Builder {
        private int nutrition;
        private float saturation;
        private boolean canAlwaysEat;

        @Override
        public FoodProperties.Builder nutrition(@NonNegative int nutrition) {
            if (nutrition < 0) {
                throw new IllegalArgumentException("nutrition cannot be negative");
            }
            this.nutrition = nutrition;
            return this;
        }

        @Override
        public FoodProperties.Builder saturation(@NonNegative float saturation) {
            if (saturation < 0.0f) {
                throw new IllegalArgumentException("saturation cannot be negative");
            }
            this.saturation = saturation;
            return this;
        }

        @Override
        public FoodProperties.Builder canAlwaysEat(boolean canAlwaysEat) {
            this.canAlwaysEat = canAlwaysEat;
            return this;
        }

        @Override
        public FoodProperties build() {
            return new FoodPropertiesImpl(this.nutrition, this.saturation, this.canAlwaysEat);
        }
    }
}

