/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ClickItemAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerActionType;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.CreativeGrabAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.DropItemAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.FillStackAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.MoveToHotbarAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ShiftClickItemAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.SpreadItemAction;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ServerboundContainerClickPacket
implements MinecraftPacket {
    public static final int CLICK_OUTSIDE_NOT_HOLDING_SLOT = -999;
    private final int containerId;
    private final int stateId;
    private final int slot;
    @NonNull
    private final ContainerActionType action;
    @NonNull
    private final ContainerAction param;
    private final @Nullable ItemStack carriedItem;
    private final @NonNull Int2ObjectMap<@Nullable ItemStack> changedSlots;

    public ServerboundContainerClickPacket(int containerId, int stateId, int slot, @NonNull ContainerActionType action, @NonNull ContainerAction param, @Nullable ItemStack carriedItem, @NonNull Map<Integer, @Nullable ItemStack> changedSlots) {
        this(containerId, stateId, slot, action, param, carriedItem, (Int2ObjectMap<ItemStack>)new Int2ObjectOpenHashMap<ItemStack>(changedSlots));
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (changedSlots == null) {
            throw new NullPointerException("changedSlots is marked non-null but is null");
        }
    }

    public ServerboundContainerClickPacket(int containerId, int stateId, int slot, @NonNull ContainerActionType action, @NonNull ContainerAction param, @Nullable ItemStack carriedItem, @NonNull Int2ObjectMap<@Nullable ItemStack> changedSlots) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (changedSlots == null) {
            throw new NullPointerException("changedSlots is marked non-null but is null");
        }
        if ((param == DropItemAction.LEFT_CLICK_OUTSIDE_NOT_HOLDING || param == DropItemAction.RIGHT_CLICK_OUTSIDE_NOT_HOLDING) && slot != 999) {
            throw new IllegalArgumentException("Slot must be -999 with param LEFT_CLICK_OUTSIDE_NOT_HOLDING or RIGHT_CLICK_OUTSIDE_NOT_HOLDING");
        }
        this.containerId = containerId;
        this.stateId = stateId;
        this.slot = slot;
        this.action = action;
        this.param = param;
        this.carriedItem = carriedItem;
        this.changedSlots = changedSlots;
    }

    public ServerboundContainerClickPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.containerId = in.readByte();
        this.stateId = helper.readVarInt(in);
        this.slot = in.readShort();
        byte param = in.readByte();
        this.action = ContainerActionType.from(in.readByte());
        if (this.action == ContainerActionType.CLICK_ITEM) {
            this.param = ClickItemAction.from(param);
        } else if (this.action == ContainerActionType.SHIFT_CLICK_ITEM) {
            this.param = ShiftClickItemAction.from(param);
        } else if (this.action == ContainerActionType.MOVE_TO_HOTBAR_SLOT) {
            this.param = MoveToHotbarAction.from(param);
        } else if (this.action == ContainerActionType.CREATIVE_GRAB_MAX_STACK) {
            this.param = CreativeGrabAction.from(param);
        } else if (this.action == ContainerActionType.DROP_ITEM) {
            this.param = DropItemAction.from(param + (this.slot != -999 ? 2 : 0));
        } else if (this.action == ContainerActionType.SPREAD_ITEM) {
            this.param = SpreadItemAction.from(param);
        } else if (this.action == ContainerActionType.FILL_STACK) {
            this.param = FillStackAction.from(param);
        } else {
            throw new IllegalStateException();
        }
        int changedItemsSize = helper.readVarInt(in);
        this.changedSlots = new Int2ObjectOpenHashMap<ItemStack>(changedItemsSize);
        for (int i = 0; i < changedItemsSize; ++i) {
            short key = in.readShort();
            ItemStack value = helper.readOptionalItemStack(in);
            this.changedSlots.put(key, value);
        }
        this.carriedItem = helper.readOptionalItemStack(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeByte(this.containerId);
        helper.writeVarInt(out, this.stateId);
        out.writeShort(this.slot);
        int param = this.param.getId();
        if (this.action == ContainerActionType.DROP_ITEM) {
            param %= 2;
        }
        out.writeByte(param);
        out.writeByte(this.action.ordinal());
        helper.writeVarInt(out, this.changedSlots.size());
        for (Int2ObjectMap.Entry entry : this.changedSlots.int2ObjectEntrySet()) {
            out.writeShort(entry.getIntKey());
            helper.writeOptionalItemStack(out, (ItemStack)entry.getValue());
        }
        helper.writeOptionalItemStack(out, this.carriedItem);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public int getSlot() {
        return this.slot;
    }

    @NonNull
    public ContainerActionType getAction() {
        return this.action;
    }

    @NonNull
    public ContainerAction getParam() {
        return this.param;
    }

    public @Nullable ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public @NonNull Int2ObjectMap<@Nullable ItemStack> getChangedSlots() {
        return this.changedSlots;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundContainerClickPacket)) {
            return false;
        }
        ServerboundContainerClickPacket other = (ServerboundContainerClickPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ContainerActionType this$action = this.getAction();
        ContainerActionType other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        ContainerAction this$param = this.getParam();
        ContainerAction other$param = other.getParam();
        if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
            return false;
        }
        ItemStack this$carriedItem = this.getCarriedItem();
        ItemStack other$carriedItem = other.getCarriedItem();
        if (this$carriedItem == null ? other$carriedItem != null : !((Object)this$carriedItem).equals(other$carriedItem)) {
            return false;
        }
        Int2ObjectMap<ItemStack> this$changedSlots = this.getChangedSlots();
        Int2ObjectMap<ItemStack> other$changedSlots = other.getChangedSlots();
        return !(this$changedSlots == null ? other$changedSlots != null : !this$changedSlots.equals(other$changedSlots));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundContainerClickPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getStateId();
        result = result * 59 + this.getSlot();
        ContainerActionType $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        ContainerAction $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        ItemStack $carriedItem = this.getCarriedItem();
        result = result * 59 + ($carriedItem == null ? 43 : ((Object)$carriedItem).hashCode());
        Int2ObjectMap<ItemStack> $changedSlots = this.getChangedSlots();
        result = result * 59 + ($changedSlots == null ? 43 : $changedSlots.hashCode());
        return result;
    }

    public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
        return "ServerboundContainerClickPacket(containerId=" + this.getContainerId() + ", stateId=" + this.getStateId() + ", slot=" + this.getSlot() + ", action=" + this.getAction() + ", param=" + this.getParam() + ", carriedItem=" + this.getCarriedItem() + ", changedSlots=" + this.getChangedSlots() + ")";
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ServerboundContainerClickPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ServerboundContainerClickPacket(containerId, this.stateId, this.slot, this.action, this.param, this.carriedItem, this.changedSlots);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ServerboundContainerClickPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ServerboundContainerClickPacket(this.containerId, stateId, this.slot, this.action, this.param, this.carriedItem, this.changedSlots);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ServerboundContainerClickPacket withSlot(int slot) {
        return this.slot == slot ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, slot, this.action, this.param, this.carriedItem, this.changedSlots);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ServerboundContainerClickPacket withAction(@NonNull ContainerActionType action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, this.slot, action, this.param, this.carriedItem, this.changedSlots);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ServerboundContainerClickPacket withParam(@NonNull ContainerAction param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.param == param ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, this.slot, this.action, param, this.carriedItem, this.changedSlots);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ServerboundContainerClickPacket withCarriedItem(@Nullable ItemStack carriedItem) {
        return this.carriedItem == carriedItem ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, this.slot, this.action, this.param, carriedItem, this.changedSlots);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ServerboundContainerClickPacket withChangedSlots(@NonNull Int2ObjectMap<@Nullable ItemStack> changedSlots) {
        if (changedSlots == null) {
            throw new NullPointerException("changedSlots is marked non-null but is null");
        }
        return this.changedSlots == changedSlots ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, this.slot, this.action, this.param, this.carriedItem, changedSlots);
    }
}

