/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.property.ContainerProperty;

public class ClientboundContainerSetDataPacket
implements MinecraftPacket {
    private final int containerId;
    private final int rawProperty;
    private final int value;

    public ClientboundContainerSetDataPacket(int containerId, ContainerProperty rawProperty, int value) {
        this(containerId, rawProperty.ordinal(), value);
    }

    public ClientboundContainerSetDataPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.containerId = in.readUnsignedByte();
        this.rawProperty = in.readShort();
        this.value = in.readShort();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeByte(this.containerId);
        out.writeShort(this.rawProperty);
        out.writeShort(this.value);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getRawProperty() {
        return this.rawProperty;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundContainerSetDataPacket)) {
            return false;
        }
        ClientboundContainerSetDataPacket other = (ClientboundContainerSetDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getRawProperty() != other.getRawProperty()) {
            return false;
        }
        return this.getValue() == other.getValue();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundContainerSetDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getRawProperty();
        result = result * 59 + this.getValue();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundContainerSetDataPacket(containerId=" + this.getContainerId() + ", rawProperty=" + this.getRawProperty() + ", value=" + this.getValue() + ")";
    }

    public @NonNull ClientboundContainerSetDataPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundContainerSetDataPacket(containerId, this.rawProperty, this.value);
    }

    public @NonNull ClientboundContainerSetDataPacket withRawProperty(int rawProperty) {
        return this.rawProperty == rawProperty ? this : new ClientboundContainerSetDataPacket(this.containerId, rawProperty, this.value);
    }

    public @NonNull ClientboundContainerSetDataPacket withValue(int value) {
        return this.value == value ? this : new ClientboundContainerSetDataPacket(this.containerId, this.rawProperty, value);
    }

    public ClientboundContainerSetDataPacket(int containerId, int rawProperty, int value) {
        this.containerId = containerId;
        this.rawProperty = rawProperty;
        this.value = value;
    }
}

