/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundServerDataPacket
implements MinecraftPacket {
    private final Component motd;
    private final byte @Nullable [] iconBytes;

    public ClientboundServerDataPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.motd = helper.readComponent(in);
        this.iconBytes = helper.readNullable(in, helper::readByteArray);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeComponent(out, this.motd);
        helper.writeNullable(out, this.iconBytes, helper::writeByteArray);
    }

    public Component getMotd() {
        return this.motd;
    }

    public byte @Nullable [] getIconBytes() {
        return this.iconBytes;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundServerDataPacket)) {
            return false;
        }
        ClientboundServerDataPacket other = (ClientboundServerDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Component this$motd = this.getMotd();
        Component other$motd = other.getMotd();
        if (this$motd == null ? other$motd != null : !this$motd.equals(other$motd)) {
            return false;
        }
        return Arrays.equals(this.getIconBytes(), other.getIconBytes());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundServerDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $motd = this.getMotd();
        result = result * 59 + ($motd == null ? 43 : $motd.hashCode());
        result = result * 59 + Arrays.hashCode(this.getIconBytes());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundServerDataPacket(motd=" + this.getMotd() + ", iconBytes=" + Arrays.toString(this.getIconBytes()) + ")";
    }

    public @NonNull ClientboundServerDataPacket withMotd(Component motd) {
        return this.motd == motd ? this : new ClientboundServerDataPacket(motd, this.iconBytes);
    }

    public @NonNull ClientboundServerDataPacket withIconBytes(byte @Nullable [] iconBytes) {
        return this.iconBytes == iconBytes ? this : new ClientboundServerDataPacket(this.motd, iconBytes);
    }

    public ClientboundServerDataPacket(Component motd, byte @Nullable [] iconBytes) {
        this.motd = motd;
        this.iconBytes = iconBytes;
    }
}

