/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.EnumSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntry;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntryAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class ClientboundPlayerInfoUpdatePacket
implements MinecraftPacket {
    private final EnumSet<PlayerListEntryAction> actions;
    private final PlayerListEntry[] entries;

    public ClientboundPlayerInfoUpdatePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.actions = helper.readEnumSet(in, PlayerListEntryAction.VALUES);
        this.entries = new PlayerListEntry[helper.readVarInt(in)];
        for (int count = 0; count < this.entries.length; ++count) {
            PlayerListEntry entry = new PlayerListEntry(helper.readUUID(in));
            for (PlayerListEntryAction action : this.actions) {
                switch (action) {
                    case ADD_PLAYER: {
                        GameProfile profile = new GameProfile(entry.getProfileId(), helper.readString(in, 16));
                        profile.setProperties(helper.readList(in, helper::readProperty));
                        entry.setProfile(profile);
                        break;
                    }
                    case INITIALIZE_CHAT: {
                        PublicKey publicKey;
                        if (!in.readBoolean()) break;
                        entry.setSessionId(helper.readUUID(in));
                        entry.setExpiresAt(in.readLong());
                        byte[] keyBytes = helper.readByteArray(in);
                        entry.setKeySignature(helper.readByteArray(in));
                        try {
                            publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
                        }
                        catch (GeneralSecurityException e) {
                            throw new IllegalStateException("Could not decode public key.", e);
                        }
                        entry.setPublicKey(publicKey);
                        break;
                    }
                    case UPDATE_GAME_MODE: {
                        GameMode gameMode = GameMode.byId(helper.readVarInt(in));
                        entry.setGameMode(gameMode);
                        break;
                    }
                    case UPDATE_LISTED: {
                        boolean listed = in.readBoolean();
                        entry.setListed(listed);
                        break;
                    }
                    case UPDATE_LATENCY: {
                        int latency = helper.readVarInt(in);
                        entry.setLatency(latency);
                        break;
                    }
                    case UPDATE_DISPLAY_NAME: {
                        Component displayName = helper.readNullable(in, helper::readComponent);
                        entry.setDisplayName(displayName);
                    }
                }
            }
            this.entries[count] = entry;
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeEnumSet(out, this.actions, PlayerListEntryAction.VALUES);
        helper.writeVarInt(out, this.entries.length);
        for (PlayerListEntry entry : this.entries) {
            helper.writeUUID(out, entry.getProfileId());
            for (PlayerListEntryAction action : this.actions) {
                switch (action) {
                    case ADD_PLAYER: {
                        GameProfile profile = entry.getProfile();
                        if (profile == null) {
                            throw new IllegalArgumentException("Cannot ADD " + entry.getProfileId() + " without a profile.");
                        }
                        helper.writeString(out, profile.getName());
                        helper.writeList(out, profile.getProperties(), helper::writeProperty);
                        break;
                    }
                    case INITIALIZE_CHAT: {
                        out.writeBoolean(entry.getPublicKey() != null);
                        if (entry.getPublicKey() == null) break;
                        helper.writeUUID(out, entry.getSessionId());
                        out.writeLong(entry.getExpiresAt());
                        helper.writeByteArray(out, entry.getPublicKey().getEncoded());
                        helper.writeByteArray(out, entry.getKeySignature());
                        break;
                    }
                    case UPDATE_GAME_MODE: {
                        helper.writeVarInt(out, entry.getGameMode().ordinal());
                        break;
                    }
                    case UPDATE_LISTED: {
                        out.writeBoolean(entry.isListed());
                        break;
                    }
                    case UPDATE_LATENCY: {
                        helper.writeVarInt(out, entry.getLatency());
                        break;
                    }
                    case UPDATE_DISPLAY_NAME: {
                        helper.writeNullable(out, entry.getDisplayName(), helper::writeComponent);
                    }
                }
            }
        }
    }

    public EnumSet<PlayerListEntryAction> getActions() {
        return this.actions;
    }

    public PlayerListEntry[] getEntries() {
        return this.entries;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerInfoUpdatePacket)) {
            return false;
        }
        ClientboundPlayerInfoUpdatePacket other = (ClientboundPlayerInfoUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EnumSet<PlayerListEntryAction> this$actions = this.getActions();
        EnumSet<PlayerListEntryAction> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        return Arrays.deepEquals(this.getEntries(), other.getEntries());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundPlayerInfoUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnumSet<PlayerListEntryAction> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEntries());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundPlayerInfoUpdatePacket(actions=" + this.getActions() + ", entries=" + Arrays.deepToString(this.getEntries()) + ")";
    }

    public @NonNull ClientboundPlayerInfoUpdatePacket withActions(EnumSet<PlayerListEntryAction> actions) {
        return this.actions == actions ? this : new ClientboundPlayerInfoUpdatePacket(actions, this.entries);
    }

    public @NonNull ClientboundPlayerInfoUpdatePacket withEntries(PlayerListEntry[] entries) {
        return this.entries == entries ? this : new ClientboundPlayerInfoUpdatePacket(this.actions, entries);
    }

    public ClientboundPlayerInfoUpdatePacket(EnumSet<PlayerListEntryAction> actions, PlayerListEntry[] entries) {
        this.actions = actions;
        this.entries = entries;
    }
}

