/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundCommandSuggestionsPacket
implements MinecraftPacket {
    private final int transactionId;
    private final int start;
    private final int length;
    @lombok.NonNull
    private final @lombok.NonNull String @lombok.NonNull [] matches;
    private final Component @lombok.NonNull [] tooltips;

    public ClientboundCommandSuggestionsPacket(int transactionId, int start, int length, @lombok.NonNull @lombok.NonNull String @lombok.NonNull [] matches, Component @lombok.NonNull [] tooltips) {
        if (matches == null) {
            throw new NullPointerException("matches is marked non-null but is null");
        }
        if (tooltips == null) {
            throw new NullPointerException("tooltips is marked non-null but is null");
        }
        if (tooltips.length != matches.length) {
            throw new IllegalArgumentException("Length of matches and tooltips must be equal.");
        }
        this.transactionId = transactionId;
        this.start = start;
        this.length = length;
        this.matches = Arrays.copyOf(matches, matches.length);
        this.tooltips = Arrays.copyOf(tooltips, tooltips.length);
    }

    public ClientboundCommandSuggestionsPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.transactionId = helper.readVarInt(in);
        this.start = helper.readVarInt(in);
        this.length = helper.readVarInt(in);
        this.matches = new String[helper.readVarInt(in)];
        this.tooltips = new Component[this.matches.length];
        for (int index = 0; index < this.matches.length; ++index) {
            this.matches[index] = helper.readString(in);
            if (!in.readBoolean()) continue;
            this.tooltips[index] = helper.readComponent(in);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.transactionId);
        helper.writeVarInt(out, this.start);
        helper.writeVarInt(out, this.length);
        helper.writeVarInt(out, this.matches.length);
        for (int index = 0; index < this.matches.length; ++index) {
            helper.writeString(out, this.matches[index]);
            Component tooltip = this.tooltips[index];
            if (tooltip != null) {
                out.writeBoolean(true);
                helper.writeComponent(out, tooltip);
                continue;
            }
            out.writeBoolean(false);
        }
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    @lombok.NonNull
    public @lombok.NonNull String @lombok.NonNull [] getMatches() {
        return this.matches;
    }

    public Component @lombok.NonNull [] getTooltips() {
        return this.tooltips;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCommandSuggestionsPacket)) {
            return false;
        }
        ClientboundCommandSuggestionsPacket other = (ClientboundCommandSuggestionsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMatches(), other.getMatches())) {
            return false;
        }
        return Arrays.deepEquals(this.getTooltips(), other.getTooltips());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundCommandSuggestionsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + this.getStart();
        result = result * 59 + this.getLength();
        result = result * 59 + Arrays.deepHashCode(this.getMatches());
        result = result * 59 + Arrays.deepHashCode(this.getTooltips());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundCommandSuggestionsPacket(transactionId=" + this.getTransactionId() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", matches=" + Arrays.deepToString(this.getMatches()) + ", tooltips=" + Arrays.deepToString(this.getTooltips()) + ")";
    }

    public @NonNull ClientboundCommandSuggestionsPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ClientboundCommandSuggestionsPacket(transactionId, this.start, this.length, this.matches, this.tooltips);
    }

    public @NonNull ClientboundCommandSuggestionsPacket withStart(int start) {
        return this.start == start ? this : new ClientboundCommandSuggestionsPacket(this.transactionId, start, this.length, this.matches, this.tooltips);
    }

    public @NonNull ClientboundCommandSuggestionsPacket withLength(int length) {
        return this.length == length ? this : new ClientboundCommandSuggestionsPacket(this.transactionId, this.start, length, this.matches, this.tooltips);
    }

    public @NonNull ClientboundCommandSuggestionsPacket withMatches(@lombok.NonNull @lombok.NonNull String @lombok.NonNull [] matches) {
        if (matches == null) {
            throw new NullPointerException("matches is marked non-null but is null");
        }
        return this.matches == matches ? this : new ClientboundCommandSuggestionsPacket(this.transactionId, this.start, this.length, matches, this.tooltips);
    }

    public @NonNull ClientboundCommandSuggestionsPacket withTooltips(Component @lombok.NonNull [] tooltips) {
        if (tooltips == null) {
            throw new NullPointerException("tooltips is marked non-null but is null");
        }
        return this.tooltips == tooltips ? this : new ClientboundCommandSuggestionsPacket(this.transactionId, this.start, this.length, this.matches, tooltips);
    }
}

