/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.common.serverbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundCustomPayloadPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Key channel;
    private final byte @lombok.NonNull [] data;

    public ServerboundCustomPayloadPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.channel = helper.readResourceLocation(in);
        this.data = helper.readByteArray(in, ByteBuf::readableBytes);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeResourceLocation(out, this.channel);
        out.writeBytes(this.data);
    }

    @lombok.NonNull
    public Key getChannel() {
        return this.channel;
    }

    public byte @lombok.NonNull [] getData() {
        return this.data;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundCustomPayloadPacket)) {
            return false;
        }
        ServerboundCustomPayloadPacket other = (ServerboundCustomPayloadPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$channel = this.getChannel();
        Key other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundCustomPayloadPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundCustomPayloadPacket(channel=" + this.getChannel() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public @NonNull ServerboundCustomPayloadPacket withChannel(@lombok.NonNull Key channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return this.channel == channel ? this : new ServerboundCustomPayloadPacket(channel, this.data);
    }

    public @NonNull ServerboundCustomPayloadPacket withData(byte @lombok.NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.data == data ? this : new ServerboundCustomPayloadPacket(this.channel, data);
    }

    public ServerboundCustomPayloadPacket(@lombok.NonNull Key channel, byte @lombok.NonNull [] data) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.channel = channel;
        this.data = data;
    }
}

