/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol;

import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.auth.SessionService;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.event.session.ConnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.DisconnectingEvent;
import org.geysermc.mcprotocollib.network.event.session.SessionAdapter;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.MinecraftConstants;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.geysermc.mcprotocollib.protocol.ServerLoginHandler;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;
import org.geysermc.mcprotocollib.protocol.data.game.RegistryEntry;
import org.geysermc.mcprotocollib.protocol.data.status.PlayerInfo;
import org.geysermc.mcprotocollib.protocol.data.status.ServerStatusInfo;
import org.geysermc.mcprotocollib.protocol.data.status.VersionInfo;
import org.geysermc.mcprotocollib.protocol.data.status.handler.ServerInfoBuilder;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundDisconnectPacket;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundKeepAlivePacket;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundKeepAlivePacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundRegistryDataPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound.ServerboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.handshake.serverbound.ClientIntentionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundConfigurationAcknowledgedPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundGameProfilePacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundHelloPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginCompressionPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginDisconnectPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundHelloPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundKeyPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundLoginAcknowledgedPacket;
import org.geysermc.mcprotocollib.protocol.packet.status.clientbound.ClientboundPongResponsePacket;
import org.geysermc.mcprotocollib.protocol.packet.status.clientbound.ClientboundStatusResponsePacket;
import org.geysermc.mcprotocollib.protocol.packet.status.serverbound.ServerboundPingRequestPacket;
import org.geysermc.mcprotocollib.protocol.packet.status.serverbound.ServerboundStatusRequestPacket;

public class ServerListener
extends SessionAdapter {
    private static final int DEFAULT_COMPRESSION_THRESHOLD = 256;
    private static final String SERVER_ID = "";
    private static final KeyPair KEY_PAIR;
    private final NbtMap networkCodec;
    private final byte[] challenge = new byte[4];
    private String username = "";
    private long lastPingTime = 0L;
    private int lastPingId = 0;

    public ServerListener(NbtMap networkCodec) {
        this.networkCodec = networkCodec;
        new Random().nextBytes(this.challenge);
    }

    @Override
    public void connected(ConnectedEvent event) {
        event.getSession().setFlag(MinecraftConstants.PING_KEY, 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void packetReceived(Session session, Packet packet) {
        MinecraftProtocol protocol = (MinecraftProtocol)session.getPacketProtocol();
        if (protocol.getState() == ProtocolState.HANDSHAKE) {
            if (!(packet instanceof ClientIntentionPacket)) return;
            ClientIntentionPacket intentionPacket = (ClientIntentionPacket)packet;
            switch (intentionPacket.getIntent()) {
                case STATUS: {
                    protocol.setState(ProtocolState.STATUS);
                    return;
                }
                case TRANSFER: {
                    if (session.getFlag(MinecraftConstants.ACCEPT_TRANSFERS_KEY, false).booleanValue()) return;
                    session.disconnect(Component.translatable("multiplayer.disconnect.transfers_disabled"));
                    return;
                }
                case LOGIN: {
                    protocol.setState(ProtocolState.LOGIN);
                    if (intentionPacket.getProtocolVersion() > protocol.getCodec().getProtocolVersion()) {
                        session.disconnect(Component.translatable("multiplayer.disconnect.incompatible", Component.text(protocol.getCodec().getMinecraftVersion())));
                        return;
                    }
                    if (intentionPacket.getProtocolVersion() >= protocol.getCodec().getProtocolVersion()) return;
                    session.disconnect(Component.translatable("multiplayer.disconnect.outdated_client", Component.text(protocol.getCodec().getMinecraftVersion())));
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid client intent: " + intentionPacket.getIntent());
                }
            }
        } else if (protocol.getState() == ProtocolState.LOGIN) {
            if (packet instanceof ServerboundHelloPacket) {
                ServerboundHelloPacket helloPacket = (ServerboundHelloPacket)packet;
                this.username = helloPacket.getUsername();
                if (session.getFlag(MinecraftConstants.VERIFY_USERS_KEY, true).booleanValue()) {
                    session.send(new ClientboundHelloPacket(SERVER_ID, KEY_PAIR.getPublic(), this.challenge, true));
                    return;
                } else {
                    new Thread(new UserAuthTask(session, null)).start();
                }
                return;
            } else if (packet instanceof ServerboundKeyPacket) {
                ServerboundKeyPacket keyPacket = (ServerboundKeyPacket)packet;
                PrivateKey privateKey = KEY_PAIR.getPrivate();
                if (!Arrays.equals(this.challenge, keyPacket.getEncryptedChallenge(privateKey))) {
                    throw new IllegalStateException("Protocol error");
                }
                SecretKey key = keyPacket.getSecretKey(privateKey);
                session.enableEncryption(protocol.enableEncryption(key));
                new Thread(new UserAuthTask(session, key)).start();
                return;
            } else {
                if (!(packet instanceof ServerboundLoginAcknowledgedPacket)) return;
                protocol.setState(ProtocolState.CONFIGURATION);
                for (Map.Entry<String, Object> entry : this.networkCodec.entrySet()) {
                    NbtMap entryTag = (NbtMap)entry.getValue();
                    Key typeTag = Key.key(entryTag.getString("type"));
                    List<NbtMap> valueTag = entryTag.getList("value", NbtType.COMPOUND);
                    ArrayList<RegistryEntry> entries = new ArrayList<RegistryEntry>();
                    for (NbtMap compoundTag : valueTag) {
                        Key nameTag = Key.key(compoundTag.getString("name"));
                        int id = compoundTag.getInt("id");
                        entries.add(id, new RegistryEntry(nameTag, compoundTag.getCompound("element")));
                    }
                    session.send(new ClientboundRegistryDataPacket(typeTag, entries));
                }
                session.send(new ClientboundFinishConfigurationPacket());
            }
            return;
        } else if (protocol.getState() == ProtocolState.STATUS) {
            if (packet instanceof ServerboundStatusRequestPacket) {
                ServerInfoBuilder builder = session.getFlag(MinecraftConstants.SERVER_INFO_BUILDER_KEY);
                if (builder == null) {
                    builder = $ -> new ServerStatusInfo(Component.text("A Minecraft Server"), new PlayerInfo(0, 20, new ArrayList<GameProfile>()), new VersionInfo(protocol.getCodec().getMinecraftVersion(), protocol.getCodec().getProtocolVersion()), null, false);
                }
                ServerStatusInfo info = builder.buildInfo(session);
                session.send(new ClientboundStatusResponsePacket(info));
                return;
            } else {
                if (!(packet instanceof ServerboundPingRequestPacket)) return;
                ServerboundPingRequestPacket pingRequestPacket = (ServerboundPingRequestPacket)packet;
                session.send(new ClientboundPongResponsePacket(pingRequestPacket.getPingTime()));
            }
            return;
        } else if (protocol.getState() == ProtocolState.GAME) {
            if (packet instanceof ServerboundKeepAlivePacket) {
                ServerboundKeepAlivePacket keepAlivePacket = (ServerboundKeepAlivePacket)packet;
                if (keepAlivePacket.getPingId() != (long)this.lastPingId) return;
                long time = System.currentTimeMillis() - this.lastPingTime;
                session.setFlag(MinecraftConstants.PING_KEY, time);
                return;
            } else if (packet instanceof ServerboundConfigurationAcknowledgedPacket) {
                protocol.setState(ProtocolState.CONFIGURATION);
                return;
            } else {
                if (!(packet instanceof ServerboundPingRequestPacket)) return;
                ServerboundPingRequestPacket pingRequestPacket = (ServerboundPingRequestPacket)packet;
                session.send(new ClientboundPongResponsePacket(pingRequestPacket.getPingTime()));
                session.disconnect(Component.translatable("multiplayer.status.request_handled"));
            }
            return;
        } else {
            if (protocol.getState() != ProtocolState.CONFIGURATION || !(packet instanceof ServerboundFinishConfigurationPacket)) return;
            protocol.setState(ProtocolState.GAME);
            ServerLoginHandler handler = session.getFlag(MinecraftConstants.SERVER_LOGIN_HANDLER_KEY);
            if (handler != null) {
                handler.loggedIn(session);
            }
            if (!session.getFlag(MinecraftConstants.AUTOMATIC_KEEP_ALIVE_MANAGEMENT, true).booleanValue()) return;
            new Thread(new KeepAliveTask(session)).start();
        }
    }

    @Override
    public void packetSent(Session session, Packet packet) {
        if (packet instanceof ClientboundLoginCompressionPacket) {
            ClientboundLoginCompressionPacket loginCompressionPacket = (ClientboundLoginCompressionPacket)packet;
            session.setCompressionThreshold(loginCompressionPacket.getThreshold(), true);
            session.send(new ClientboundGameProfilePacket(session.getFlag(MinecraftConstants.PROFILE_KEY), true));
        }
    }

    @Override
    public void disconnecting(DisconnectingEvent event) {
        MinecraftProtocol protocol = (MinecraftProtocol)event.getSession().getPacketProtocol();
        if (protocol.getState() == ProtocolState.LOGIN) {
            event.getSession().send(new ClientboundLoginDisconnectPacket(event.getReason()));
        } else if (protocol.getState() == ProtocolState.GAME) {
            event.getSession().send(new ClientboundDisconnectPacket(event.getReason()));
        }
    }

    static {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(1024);
            KEY_PAIR = gen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to generate server key pair.", e);
        }
    }

    private class UserAuthTask
    implements Runnable {
        private final Session session;
        private final SecretKey key;

        @Override
        public void run() {
            GameProfile profile;
            if (this.key != null) {
                SessionService sessionService = this.session.getFlag(MinecraftConstants.SESSION_SERVICE_KEY, new SessionService());
                try {
                    profile = sessionService.getProfileByServer(ServerListener.this.username, SessionService.getServerId(ServerListener.SERVER_ID, KEY_PAIR.getPublic(), this.key));
                }
                catch (IOException e) {
                    this.session.disconnect(Component.translatable("multiplayer.disconnect.authservers_down"), (Throwable)e);
                    return;
                }
                if (profile == null) {
                    this.session.disconnect(Component.translatable("multiplayer.disconnect.unverified_username"));
                    return;
                }
            } else {
                profile = new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + ServerListener.this.username).getBytes()), ServerListener.this.username);
            }
            this.session.setFlag(MinecraftConstants.PROFILE_KEY, profile);
            int threshold = this.session.getFlag(MinecraftConstants.SERVER_COMPRESSION_THRESHOLD, 256);
            this.session.send(new ClientboundLoginCompressionPacket(threshold));
        }

        public UserAuthTask(Session session, SecretKey key) {
            this.session = session;
            this.key = key;
        }
    }

    private class KeepAliveTask
    implements Runnable {
        private final Session session;

        @Override
        public void run() {
            while (this.session.isConnected()) {
                ServerListener.this.lastPingTime = System.currentTimeMillis();
                ServerListener.this.lastPingId = (int)ServerListener.this.lastPingTime;
                this.session.send(new ClientboundKeepAlivePacket(ServerListener.this.lastPingId));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public KeepAliveTask(Session session) {
            this.session = session;
        }
    }
}

