/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundBlockDestructionPacket;

@Translator(packet=ClientboundBlockDestructionPacket.class)
public class JavaBlockDestructionTranslator
extends PacketTranslator<ClientboundBlockDestructionPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundBlockDestructionPacket packet) {
        int state = session.getGeyser().getWorldManager().getBlockAt(session, packet.getPosition().getX(), packet.getPosition().getY(), packet.getPosition().getZ());
        int breakTime = (int)(65535.0 / Math.ceil(BlockUtils.getBreakTime(session, BlockState.of(state).block(), ItemMapping.AIR, null, false) * 20.0));
        LevelEventPacket levelEventPacket = new LevelEventPacket();
        levelEventPacket.setPosition(packet.getPosition().toFloat());
        levelEventPacket.setType(LevelEvent.BLOCK_START_BREAK);
        switch (packet.getStage()) {
            case STAGE_1: {
                levelEventPacket.setData(breakTime);
                break;
            }
            case STAGE_2: {
                levelEventPacket.setData(breakTime * 2);
                break;
            }
            case STAGE_3: {
                levelEventPacket.setData(breakTime * 3);
                break;
            }
            case STAGE_4: {
                levelEventPacket.setData(breakTime * 4);
                break;
            }
            case STAGE_5: {
                levelEventPacket.setData(breakTime * 5);
                break;
            }
            case STAGE_6: {
                levelEventPacket.setData(breakTime * 6);
                break;
            }
            case STAGE_7: {
                levelEventPacket.setData(breakTime * 7);
                break;
            }
            case STAGE_8: {
                levelEventPacket.setData(breakTime * 8);
                break;
            }
            case STAGE_9: {
                levelEventPacket.setData(breakTime * 9);
                break;
            }
            case STAGE_10: {
                levelEventPacket.setData(breakTime * 10);
                break;
            }
            case RESET: {
                levelEventPacket.setType(LevelEvent.BLOCK_STOP_BREAK);
                levelEventPacket.setData(0);
            }
        }
        session.sendUpstreamPacket(levelEventPacket);
    }
}

