/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import org.cloudburstmc.protocol.bedrock.packet.TextPacket;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.TranslatableComponent;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundSystemChatPacket;

@Translator(packet=ClientboundSystemChatPacket.class)
public class JavaSystemChatTranslator
extends PacketTranslator<ClientboundSystemChatPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSystemChatPacket packet) {
        TranslatableComponent component;
        Component component2 = packet.getContent();
        if (component2 instanceof TranslatableComponent && (component = (TranslatableComponent)component2).key().equals("chat.disabled.missingProfileKey") && Boolean.parseBoolean(System.getProperty("Geyser.PrintSecureChatInformation", "true"))) {
            session.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.chat.secure_info_1", session.locale()));
            session.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.chat.secure_info_2", session.locale(), "https://geysermc.link/secure-chat"));
        }
        TextPacket textPacket = new TextPacket();
        textPacket.setPlatformChatId("");
        textPacket.setSourceName("");
        textPacket.setXuid(session.getAuthData().xuid());
        textPacket.setType(packet.isOverlay() ? TextPacket.Type.JUKEBOX_POPUP : TextPacket.Type.SYSTEM);
        textPacket.setNeedsTranslation(false);
        if (packet.isOverlay()) {
            textPacket.setMessage("\u00a7f" + MessageTranslator.convertMessage(packet.getContent(), session.locale()));
        } else {
            textPacket.setMessage(MessageTranslator.convertMessage(packet.getContent(), session.locale()));
        }
        if (session.isSentSpawnPacket()) {
            session.sendUpstreamPacket(textPacket);
        } else {
            session.getUpstream().queuePostStartGamePacket(textPacket);
        }
    }
}

