/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.cloudburstmc.protocol.bedrock.data.command.CommandData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumConstraint;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandOverloadData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandParam;
import org.cloudburstmc.protocol.bedrock.data.command.CommandParamData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;
import org.cloudburstmc.protocol.bedrock.packet.AvailableCommandsPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.EventBus;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.downstream.ServerDefineCommandsEvent;
import org.geysermc.geyser.api.event.java.ServerDefineCommandsEvent;
import org.geysermc.geyser.command.GeyserCommandManager;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.Hash;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.command.CommandNode;
import org.geysermc.mcprotocollib.protocol.data.game.command.CommandParser;
import org.geysermc.mcprotocollib.protocol.data.game.command.properties.CommandProperties;
import org.geysermc.mcprotocollib.protocol.data.game.command.properties.ResourceProperties;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundCommandsPacket;

@Translator(packet=ClientboundCommandsPacket.class)
public class JavaCommandsTranslator
extends PacketTranslator<ClientboundCommandsPacket> {
    private static final Supplier<String[]> ALL_BLOCK_NAMES = Suppliers.memoize(() -> (String[])((List)BlockRegistries.JAVA_BLOCKS.get()).stream().map(block -> block.javaIdentifier().toString()).toArray(String[]::new));
    private static final String[] ALL_EFFECT_IDENTIFIERS = EntityUtils.getAllEffectIdentifiers();
    private static final String[] ATTRIBUTES = AttributeType.Builtin.BUILTIN.values().stream().map(type -> type.getIdentifier().asString()).toList().toArray(new String[0]);
    private static final String[] ENUM_BOOLEAN = new String[]{"true", "false"};
    private static final String[] VALID_COLORS;
    private static final String[] VALID_SCOREBOARD_SLOTS;
    private static final Hash.Strategy<BedrockCommandInfo> PARAM_STRATEGY;

    @Override
    public void translate(GeyserSession session, ClientboundCommandsPacket packet) {
        if (!session.getGeyser().getConfig().isCommandSuggestions()) {
            session.getGeyser().getLogger().debug("Not sending translated command suggestions as they are disabled.");
            AvailableCommandsPacket emptyPacket = new AvailableCommandsPacket();
            session.sendUpstreamPacket(emptyPacket);
            return;
        }
        GeyserCommandManager manager = session.getGeyser().commandManager();
        CommandNode[] nodes = packet.getNodes();
        ArrayList<CommandData> commandData = new ArrayList<CommandData>();
        IntOpenHashSet commandNodes = new IntOpenHashSet();
        HashSet<String> knownAliases = new HashSet<String>();
        Object2ObjectOpenCustomHashMap<BedrockCommandInfo, Set> commands = new Object2ObjectOpenCustomHashMap<BedrockCommandInfo, Set>(PARAM_STRATEGY);
        Int2ObjectOpenHashMap<List> commandArgs = new Int2ObjectOpenHashMap<List>();
        CommandNode rootNode = nodes[packet.getFirstNodeIndex()];
        for (int nodeIndex : rootNode.getChildIndices()) {
            CommandNode node = nodes[nodeIndex];
            if (!commandNodes.add(nodeIndex) || !knownAliases.add(node.getName().toLowerCase(Locale.ROOT))) continue;
            if (node.getChildIndices().length >= 1) {
                for (int childIndex : node.getChildIndices()) {
                    commandArgs.computeIfAbsent(nodeIndex, $ -> new ArrayList()).add(nodes[childIndex]);
                }
            }
            CommandOverloadData[] commandOverloadDataArray = JavaCommandsTranslator.getParams(session, nodes[nodeIndex], nodes);
            commands.computeIfAbsent(new BedrockCommandInfo(node.getName().toLowerCase(Locale.ROOT), manager.description(node.getName().toLowerCase(Locale.ROOT)), commandOverloadDataArray), index -> new HashSet()).add(node.getName().toLowerCase());
        }
        EventBus<EventRegistrar> eventBus = session.getGeyser().eventBus();
        org.geysermc.geyser.api.event.java.ServerDefineCommandsEvent event = new org.geysermc.geyser.api.event.java.ServerDefineCommandsEvent(session, commands.keySet());
        eventBus.fire(event);
        if (event.isCancelled()) {
            return;
        }
        ServerDefineCommandsEvent oldEvent = new ServerDefineCommandsEvent(session, commands.keySet());
        eventBus.fire(oldEvent);
        if (oldEvent.isCancelled()) {
            return;
        }
        Set<CommandData.Flag> flags = Set.of();
        for (Map.Entry entry : commands.entrySet()) {
            String commandName = (String)((Set)entry.getValue()).iterator().next();
            LinkedHashMap<String, Set<CommandEnumConstraint>> values = new LinkedHashMap<String, Set<CommandEnumConstraint>>();
            for (String s : (Set)entry.getValue()) {
                values.put(s, EnumSet.of(CommandEnumConstraint.ALLOW_ALIASES));
            }
            CommandEnumData aliases = new CommandEnumData(commandName + "Aliases", values, false);
            CommandData data = new CommandData(commandName, ((BedrockCommandInfo)entry.getKey()).description(), flags, CommandPermission.ANY, aliases, Collections.emptyList(), ((BedrockCommandInfo)entry.getKey()).paramData());
            commandData.add(data);
        }
        AvailableCommandsPacket availableCommandsPacket = new AvailableCommandsPacket();
        availableCommandsPacket.getCommands().addAll(commandData);
        session.getGeyser().getLogger().debug("Sending command packet of " + commandData.size() + " commands");
        session.sendUpstreamPacket(availableCommandsPacket);
    }

    private static CommandOverloadData[] getParams(GeyserSession session, CommandNode commandNode, CommandNode[] allNodes) {
        if (commandNode.getRedirectIndex().isPresent()) {
            int redirectIndex = commandNode.getRedirectIndex().getAsInt();
            GeyserImpl.getInstance().getLogger().debug("Redirecting command " + commandNode.getName() + " to " + allNodes[redirectIndex].getName());
            commandNode = allNodes[redirectIndex];
        }
        if (commandNode.getChildIndices().length >= 1) {
            ParamInfo rootParam = new ParamInfo(commandNode, null);
            rootParam.buildChildren(new CommandBuilderContext(session), allNodes);
            List<CommandOverloadData> treeData = rootParam.getTree();
            return treeData.toArray(new CommandOverloadData[0]);
        }
        return new CommandOverloadData[0];
    }

    private static Object mapCommandType(CommandBuilderContext context, CommandNode node) {
        CommandParser parser = node.getParser();
        if (parser == null) {
            return CommandParam.STRING;
        }
        return switch (parser) {
            case CommandParser.FLOAT, CommandParser.ROTATION, CommandParser.DOUBLE -> CommandParam.FLOAT;
            case CommandParser.INTEGER, CommandParser.LONG -> CommandParam.INT;
            case CommandParser.ENTITY, CommandParser.GAME_PROFILE -> CommandParam.TARGET;
            case CommandParser.BLOCK_POS -> CommandParam.BLOCK_POSITION;
            case CommandParser.COLUMN_POS, CommandParser.VEC3 -> CommandParam.POSITION;
            case CommandParser.MESSAGE -> CommandParam.MESSAGE;
            case CommandParser.NBT_COMPOUND_TAG, CommandParser.NBT_TAG, CommandParser.NBT_PATH -> CommandParam.JSON;
            case CommandParser.RESOURCE_LOCATION, CommandParser.FUNCTION -> CommandParam.FILE_PATH;
            case CommandParser.BOOL -> ENUM_BOOLEAN;
            case CommandParser.OPERATION -> CommandParam.OPERATOR;
            case CommandParser.BLOCK_STATE -> ALL_BLOCK_NAMES.get();
            case CommandParser.ITEM_STACK -> context.getItemNames();
            case CommandParser.COLOR -> VALID_COLORS;
            case CommandParser.SCOREBOARD_SLOT -> VALID_SCOREBOARD_SLOTS;
            case CommandParser.RESOURCE -> JavaCommandsTranslator.handleResource(context, ((ResourceProperties)node.getProperties()).getRegistryKey(), false);
            case CommandParser.RESOURCE_OR_TAG -> JavaCommandsTranslator.handleResource(context, ((ResourceProperties)node.getProperties()).getRegistryKey(), true);
            case CommandParser.DIMENSION -> context.session.getLevels();
            case CommandParser.TEAM -> context.getTeams();
            default -> CommandParam.STRING;
        };
    }

    private static Object handleResource(CommandBuilderContext context, Key resource, boolean tags) {
        return switch (resource.asString()) {
            case "minecraft:attribute" -> ATTRIBUTES;
            case "minecraft:enchantment" -> context.getEnchantments();
            case "minecraft:entity_type" -> context.getEntityTypes();
            case "minecraft:mob_effect" -> ALL_EFFECT_IDENTIFIERS;
            case "minecraft:worldgen/biome" -> {
                if (tags) {
                    yield context.getBiomesWithTags();
                }
                yield context.getBiomes();
            }
            default -> CommandParam.STRING;
        };
    }

    static {
        PARAM_STRATEGY = new Hash.Strategy<BedrockCommandInfo>(){

            @Override
            public int hashCode(BedrockCommandInfo o) {
                int paramHash = Arrays.deepHashCode(o.paramData());
                return 31 * paramHash + o.description().hashCode();
            }

            @Override
            public boolean equals(BedrockCommandInfo a, BedrockCommandInfo b) {
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                if (!a.description().equals(b.description())) {
                    return false;
                }
                if (a.paramData().length != b.paramData().length) {
                    return false;
                }
                for (int i = 0; i < a.paramData().length; ++i) {
                    CommandParamData[] b1;
                    CommandParamData[] a1 = a.paramData()[i].getOverloads();
                    if (a1.length != (b1 = b.paramData()[i].getOverloads()).length) {
                        return false;
                    }
                    for (int j = 0; j < a1.length; ++j) {
                        if (a1[j].equals(b1[j])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        ArrayList<String> validColors = new ArrayList<String>(NamedTextColor.NAMES.keys());
        validColors.add("reset");
        VALID_COLORS = validColors.toArray(new String[0]);
        ArrayList<String> teamOptions = new ArrayList<String>(Arrays.asList("list", "sidebar", "belowName"));
        for (String color : NamedTextColor.NAMES.keys()) {
            teamOptions.add("sidebar.team." + color);
        }
        VALID_SCOREBOARD_SLOTS = teamOptions.toArray(new String[0]);
    }

    private record BedrockCommandInfo(String name, String description, CommandOverloadData[] paramData) implements ServerDefineCommandsEvent.CommandInfo,
    ServerDefineCommandsEvent.CommandInfo
    {
    }

    private static class ParamInfo {
        private final CommandNode paramNode;
        private final CommandParamData paramData;
        private final List<ParamInfo> children;

        public ParamInfo(CommandNode paramNode, CommandParamData paramData) {
            this.paramNode = paramNode;
            this.paramData = paramData;
            this.children = new ArrayList<ParamInfo>();
        }

        public void buildChildren(CommandBuilderContext context, CommandNode[] allNodes) {
            for (int paramID : this.paramNode.getChildIndices()) {
                CommandNode paramNode = allNodes[paramID];
                if (paramNode == this.paramNode) continue;
                if (paramNode.getParser() == null) {
                    boolean foundCompatible = false;
                    for (int i = 0; i < this.children.size(); ++i) {
                        ParamInfo enumParamInfo = this.children.get(i);
                        if (!this.isCompatible(allNodes, enumParamInfo.getParamNode(), paramNode)) continue;
                        foundCompatible = true;
                        LinkedHashMap<String, Set<CommandEnumConstraint>> values = new LinkedHashMap<String, Set<CommandEnumConstraint>>(enumParamInfo.getParamData().getEnumData().getValues());
                        values.put(paramNode.getName(), Set.of());
                        CommandEnumData enumData = new CommandEnumData(enumParamInfo.getParamData().getEnumData().getName(), values, false);
                        CommandParamData commandParamData = new CommandParamData();
                        commandParamData.setName(enumParamInfo.getParamData().getName());
                        commandParamData.setOptional(this.paramNode.isExecutable());
                        commandParamData.setEnumData(enumData);
                        this.children.set(i, new ParamInfo(enumParamInfo.getParamNode(), commandParamData));
                        break;
                    }
                    if (foundCompatible) continue;
                    LinkedHashMap<String, Set<CommandEnumConstraint>> map = new LinkedHashMap<String, Set<CommandEnumConstraint>>();
                    map.put(paramNode.getName(), Set.of());
                    CommandEnumData enumData = new CommandEnumData(paramNode.getName(), map, false);
                    CommandParamData commandParamData = new CommandParamData();
                    commandParamData.setName(paramNode.getName());
                    commandParamData.setOptional(this.paramNode.isExecutable());
                    commandParamData.setEnumData(enumData);
                    this.children.add(new ParamInfo(paramNode, commandParamData));
                    continue;
                }
                Object mappedType = JavaCommandsTranslator.mapCommandType(context, paramNode);
                CommandEnumData enumData = null;
                CommandParam type = null;
                boolean optional = this.paramNode.isExecutable();
                if (mappedType instanceof CommandEnumData) {
                    enumData = (CommandEnumData)mappedType;
                } else if (mappedType instanceof String[]) {
                    LinkedHashMap<String, Set<CommandEnumConstraint>> map = new LinkedHashMap<String, Set<CommandEnumConstraint>>();
                    for (String s : (String[])mappedType) {
                        map.put(s, Set.of());
                    }
                    enumData = new CommandEnumData(ParamInfo.getEnumDataName(paramNode).toLowerCase(Locale.ROOT), map, false);
                } else {
                    type = (CommandParam)mappedType;
                    if (optional && type == CommandParam.MESSAGE && (this.paramData.getType() == CommandParam.STRING || this.paramData.getType() == CommandParam.TARGET)) {
                        optional = false;
                    }
                }
                CommandParamData commandParamData = new CommandParamData();
                commandParamData.setName(paramNode.getName());
                commandParamData.setOptional(optional);
                commandParamData.setEnumData(enumData);
                commandParamData.setType(type);
                this.children.add(new ParamInfo(paramNode, commandParamData));
            }
            Object object = this.children.iterator();
            while (object.hasNext()) {
                ParamInfo child = (ParamInfo)object.next();
                child.buildChildren(context, allNodes);
            }
        }

        private static String getEnumDataName(CommandNode node) {
            CommandProperties commandProperties = node.getProperties();
            if (commandProperties instanceof ResourceProperties) {
                ResourceProperties properties = (ResourceProperties)commandProperties;
                Key registryKey = properties.getRegistryKey();
                return registryKey.value();
            }
            return node.getParser().name();
        }

        private boolean isCompatible(CommandNode[] allNodes, CommandNode a, CommandNode b) {
            if (a == b) {
                return true;
            }
            if (a.getParser() != b.getParser()) {
                return false;
            }
            if (a.getChildIndices().length != b.getChildIndices().length) {
                return false;
            }
            for (int i = 0; i < a.getChildIndices().length; ++i) {
                boolean hasSimilarity = false;
                CommandNode a1 = allNodes[a.getChildIndices()[i]];
                for (int j = 0; j < b.getChildIndices().length; ++j) {
                    if (!this.isCompatible(allNodes, a1, allNodes[b.getChildIndices()[j]])) continue;
                    hasSimilarity = true;
                    break;
                }
                if (hasSimilarity) continue;
                return false;
            }
            return true;
        }

        public List<CommandOverloadData> getTree() {
            ArrayList<CommandOverloadData> treeParamData = new ArrayList<CommandOverloadData>();
            for (ParamInfo child : this.children) {
                List<CommandOverloadData> childTree = child.getTree();
                for (CommandOverloadData subChildData : childTree) {
                    CommandParamData[] subChild = subChildData.getOverloads();
                    CommandParamData[] tmpTree = new CommandParamData[subChild.length + 1];
                    tmpTree[0] = child.getParamData();
                    System.arraycopy(subChild, 0, tmpTree, 1, subChild.length);
                    treeParamData.add(new CommandOverloadData(false, tmpTree));
                }
                if (childTree.size() != 0) continue;
                treeParamData.add(new CommandOverloadData(false, new CommandParamData[]{child.getParamData()}));
            }
            return treeParamData;
        }

        public CommandNode getParamNode() {
            return this.paramNode;
        }

        public CommandParamData getParamData() {
            return this.paramData;
        }

        public List<ParamInfo> getChildren() {
            return this.children;
        }

        public String toString() {
            return "JavaCommandsTranslator.ParamInfo(paramNode=" + this.getParamNode() + ", paramData=" + this.getParamData() + ", children=" + this.getChildren() + ")";
        }
    }

    @MonotonicNonNull
    private static class CommandBuilderContext {
        private final GeyserSession session;
        private Object biomesWithTags;
        private Object biomesNoTags;
        private String[] enchantments;
        private String[] entityTypes;
        private String[] itemNames;
        private CommandEnumData teams;

        CommandBuilderContext(GeyserSession session) {
            this.session = session;
        }

        private Object getBiomes() {
            if (this.biomesNoTags != null) {
                return this.biomesNoTags;
            }
            String[] identifiers = this.session.getGeyser().getWorldManager().getBiomeIdentifiers(false);
            this.biomesNoTags = identifiers != null ? identifiers : CommandParam.STRING;
            return this.biomesNoTags;
        }

        private Object getBiomesWithTags() {
            if (this.biomesWithTags != null) {
                return this.biomesWithTags;
            }
            String[] identifiers = this.session.getGeyser().getWorldManager().getBiomeIdentifiers(true);
            this.biomesWithTags = identifiers != null ? identifiers : CommandParam.STRING;
            return this.biomesWithTags;
        }

        private String[] getEnchantments() {
            if (this.enchantments != null) {
                return this.enchantments;
            }
            this.enchantments = (String[])this.session.getRegistryCache().enchantments().values().stream().map(Enchantment::identifier).toArray(String[]::new);
            return this.enchantments;
        }

        private String[] getEntityTypes() {
            if (this.entityTypes != null) {
                return this.entityTypes;
            }
            this.entityTypes = ((Map)Registries.JAVA_ENTITY_IDENTIFIERS.get()).keySet().toArray(new String[0]);
            return this.entityTypes;
        }

        public String[] getItemNames() {
            if (this.itemNames != null) {
                return this.itemNames;
            }
            this.itemNames = ((Map)Registries.JAVA_ITEM_IDENTIFIERS.get()).keySet().toArray(new String[0]);
            return this.itemNames;
        }

        private CommandEnumData getTeams() {
            if (this.teams != null) {
                return this.teams;
            }
            this.teams = new CommandEnumData("Geyser_Teams", this.session.getWorldCache().getScoreboard().getTeamNames(), true);
            return this.teams;
        }
    }
}

