/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.common.util.TriConsumer;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.VAULT})
public class VaultBlockEntityTranslator
extends BlockEntityTranslator {
    private static final Map<String, TriConsumer<GeyserSession, NbtMap, DataComponents>> DATA_COMPONENT_DECODERS = Map.of("minecraft:potion_contents", (session, tag, components) -> {
        String potionId = tag.getString("potion");
        Potion potion = Potion.getByJavaIdentifier(potionId);
        components.put(DataComponentType.POTION_CONTENTS, potion.toComponent());
    }, "minecraft:enchantments", (session, tag, components) -> {
        NbtMap levels = tag.getCompound("levels");
        List<Enchantment> enchantmentRegistry = session.getRegistryCache().enchantments().values();
        Int2ObjectOpenHashMap<Integer> enchantments = new Int2ObjectOpenHashMap<Integer>(levels.size());
        for (Map.Entry<String, Object> entry : levels.entrySet()) {
            for (int i = 0; i < enchantmentRegistry.size(); ++i) {
                if (!enchantmentRegistry.get(i).identifier().equals(entry.getKey())) continue;
                enchantments.put(i, (Integer)entry.getValue());
            }
        }
        components.put(DataComponentType.ENCHANTMENTS, new ItemEnchantments(enchantments, true));
    });

    @Override
    public NbtMap getBlockEntityTag(GeyserSession session, BlockEntityType type, int x, int y, int z, @Nullable NbtMap javaNbt, BlockState blockState) {
        NbtMapBuilder builder = NbtMap.builder();
        if (javaNbt != null) {
            this.translateTag(session, builder, javaNbt, blockState);
        }
        return builder.build();
    }

    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        NbtMap sharedData = javaNbt.getCompound("shared_data");
        NbtMap item = sharedData.getCompound("display_item");
        ItemMapping mapping = session.getItemMappings().getMapping(item.getString("id"));
        if (mapping == null) {
            bedrockNbt.putCompound("display_item", NbtMap.builder().putByte("Count", (byte)0).putShort("Damage", (short)0).putString("Name", "").putByte("WasPickedUp", (byte)0).build());
        } else {
            NbtMapBuilder itemAsNbt;
            int count = item.getInt("count");
            NbtMap componentsTag = item.getCompound("components");
            if (!componentsTag.isEmpty()) {
                DataComponents components = new DataComponents(new HashMap());
                for (Map.Entry<String, Object> entry : componentsTag.entrySet()) {
                    TriConsumer<GeyserSession, NbtMap, DataComponents> consumer = DATA_COMPONENT_DECODERS.get(entry.getKey());
                    if (consumer == null) continue;
                    consumer.accept(session, (NbtMap)entry.getValue(), components);
                }
                ItemData bedrockItem = ItemTranslator.translateToBedrock(session, mapping.getJavaItem(), mapping, count, components).build();
                itemAsNbt = BedrockItemBuilder.createItemNbt(mapping, bedrockItem.getCount(), bedrockItem.getDamage());
                if (bedrockItem.getTag() != null) {
                    itemAsNbt.putCompound("tag", bedrockItem.getTag());
                }
            } else {
                itemAsNbt = BedrockItemBuilder.createItemNbt(mapping, count, mapping.getBedrockData());
            }
            bedrockNbt.putCompound("display_item", itemAsNbt.build());
        }
        List<int[]> connectedPlayers = sharedData.getList("connected_players", NbtType.INT_ARRAY);
        LongArrayList bedrockPlayers = new LongArrayList(connectedPlayers.size());
        for (int[] player : connectedPlayers) {
            UUID uuid = VaultBlockEntityTranslator.uuidFromIntArray(player);
            if (uuid.equals(session.getPlayerEntity().getUuid())) {
                bedrockPlayers.add(session.getPlayerEntity().getGeyserId());
                continue;
            }
            PlayerEntity playerEntity = session.getEntityCache().getPlayerEntity(uuid);
            if (playerEntity == null) continue;
            bedrockPlayers.add(playerEntity.getGeyserId());
        }
        bedrockNbt.putList("connected_players", NbtType.LONG, bedrockPlayers);
        bedrockNbt.putFloat("connected_particle_range", (float)sharedData.getDouble("connected_particles_range", 4.5));
    }

    private static UUID uuidFromIntArray(int[] parts) {
        return new UUID((long)parts[0] << 32 | (long)parts[1] & 0xFFFFFFFFL, (long)parts[2] << 32 | (long)parts[3] & 0xFFFFFFFFL);
    }
}

