/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.Map;
import java.util.WeakHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.GlobalPos;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.LodestoneTracker;

public final class LodestoneCache {
    private final Map<GeyserItemStack, LodestonePos> activeLodestones = new WeakHashMap<GeyserItemStack, LodestonePos>();
    private final Int2ObjectMap<LodestonePos> lodestones = new Int2ObjectOpenHashMap<LodestonePos>();
    private int id = 1;

    public void cacheInventoryItem(GeyserItemStack itemStack, LodestoneTracker tracker) {
        if (!tracker.isTracked()) {
            return;
        }
        GlobalPos position = tracker.getPos();
        if (position == null) {
            return;
        }
        int x = position.getX();
        int y = position.getY();
        int z = position.getZ();
        Key dim = position.getDimension();
        for (LodestonePos pos : this.activeLodestones.values()) {
            if (!pos.equals(x, y, z, dim)) continue;
            this.activeLodestones.put(itemStack, pos);
            return;
        }
        for (LodestonePos pos : this.lodestones.values()) {
            if (!pos.equals(x, y, z, dim)) continue;
            this.activeLodestones.put(itemStack, pos);
            return;
        }
        this.activeLodestones.put(itemStack, new LodestonePos(this.id++, x, y, z, dim));
    }

    public int store(LodestoneTracker tracker) {
        if (!tracker.isTracked()) {
            return 0;
        }
        GlobalPos position = tracker.getPos();
        if (position == null) {
            return 0;
        }
        int x = position.getX();
        int y = position.getY();
        int z = position.getZ();
        Key dim = position.getDimension();
        for (LodestonePos lodestonePos : this.activeLodestones.values()) {
            if (!lodestonePos.equals(x, y, z, dim)) continue;
            return lodestonePos.id;
        }
        for (Int2ObjectMap.Entry entry : this.lodestones.int2ObjectEntrySet()) {
            if (!((LodestonePos)entry.getValue()).equals(x, y, z, dim)) continue;
            return entry.getIntKey();
        }
        this.lodestones.put(this.id, new LodestonePos(this.id, x, y, z, dim));
        return this.id++;
    }

    public @Nullable LodestonePos getPos(int id) {
        LodestonePos pos = (LodestonePos)this.lodestones.remove(id);
        if (pos != null) {
            return pos;
        }
        for (LodestonePos activePos : this.activeLodestones.values()) {
            if (activePos.id != id) continue;
            return activePos;
        }
        return null;
    }

    public void clear() {
        this.activeLodestones.clear();
        this.lodestones.clear();
    }

    public record LodestonePos(int id, int x, int y, int z, Key dimension) {
        boolean equals(int x, int y, int z, Key dimension) {
            return this.x == x && this.y == y && this.z == z && this.dimension.equals(dimension);
        }
    }
}

