/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.nbt.NbtUtils;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.Pair;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.loader.MultiResourceRegistryLoader;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;
import org.geysermc.geyser.translator.collision.OtherCollision;
import org.geysermc.geyser.translator.collision.SolidCollision;
import org.geysermc.geyser.util.FileUtils;

public class CollisionRegistryLoader
extends MultiResourceRegistryLoader<String, List<BlockCollision>> {
    @Override
    public List<BlockCollision> load(Pair<String, String> input) {
        List<BoundingBox[]> collisionList;
        int[] indices;
        IdentityHashMap annotationMap = new IdentityHashMap();
        for (Class<?> clazz : FileUtils.getGeneratedClassesForAnnotation(CollisionRemapper.class.getName())) {
            GeyserImpl.getInstance().getLogger().debug("Found annotated collision translator: " + clazz.getCanonicalName());
            CollisionRemapper collisionRemapper = clazz.getAnnotation(CollisionRemapper.class);
            annotationMap.put(clazz, new CollisionInfo(collisionRemapper, Pattern.compile(collisionRemapper.regex())));
        }
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(input.value());){
            NbtMap collisionData = (NbtMap)NbtUtils.createGZIPReader(stream).readTag();
            indices = collisionData.getIntArray("indices");
            collisionList = this.loadBoundingBoxes(collisionData.getList("collisions", NbtType.LIST));
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load collision data", e);
        }
        List blockStates = (List)BlockRegistries.BLOCK_STATES.get();
        ObjectArrayList<BlockCollision> collisions = new ObjectArrayList<BlockCollision>(blockStates.size());
        Object2ObjectOpenHashMap<BlockCollision, BlockCollision> collisionInstances = new Object2ObjectOpenHashMap<BlockCollision, BlockCollision>();
        for (int i = 0; i < blockStates.size(); ++i) {
            BlockState state = (BlockState)blockStates.get(i);
            if (state == null) {
                GeyserImpl.getInstance().getLogger().warning("Missing block state for Java block " + i);
                continue;
            }
            BlockCollision newCollision = this.instantiateCollision(state, annotationMap, indices[i], collisionList);
            if (newCollision != null) {
                BlockCollision existingInstance = (BlockCollision)collisionInstances.get(newCollision);
                if (existingInstance != null) {
                    newCollision = existingInstance;
                } else {
                    collisionInstances.put(newCollision, newCollision);
                }
            }
            collisions.add(newCollision);
        }
        collisions.trim();
        return collisions;
    }

    private @Nullable BlockCollision instantiateCollision(BlockState state, Map<Class<?>, CollisionInfo> annotationMap, int collisionIndex, List<BoundingBox[]> collisionList) {
        String blockName = state.block().javaIdentifier().value();
        for (Map.Entry<Class<?>, CollisionInfo> collisionRemappers : annotationMap.entrySet()) {
            Class<?> type = collisionRemappers.getKey();
            CollisionInfo collisionInfo = collisionRemappers.getValue();
            CollisionRemapper annotation = collisionInfo.collisionRemapper;
            if (!collisionInfo.pattern.matcher(blockName).find()) continue;
            try {
                if (annotation.passDefaultBoxes()) {
                    BoundingBox[] defaultBoxes = collisionList.get(collisionIndex);
                    return (BlockCollision)type.getDeclaredConstructor(BlockState.class, BoundingBox[].class).newInstance(state, defaultBoxes);
                }
                return (BlockCollision)type.getDeclaredConstructor(BlockState.class).newInstance(state);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (collisionIndex == 0) {
            return null;
        }
        if (collisionIndex == 1) {
            return new SolidCollision(state);
        }
        return new OtherCollision(collisionList.get(collisionIndex));
    }

    private List<BoundingBox[]> loadBoundingBoxes(List<NbtList> collisionNode) {
        ObjectArrayList<BoundingBox[]> collisions = new ObjectArrayList<BoundingBox[]>();
        for (int collisionIndex = 0; collisionIndex < collisionNode.size(); ++collisionIndex) {
            NbtList boundingBoxArray = collisionNode.get(collisionIndex);
            BoundingBox[] boundingBoxes = new BoundingBox[boundingBoxArray.size()];
            for (int i = 0; i < boundingBoxArray.size(); ++i) {
                NbtList boxProperties = (NbtList)boundingBoxArray.get(i);
                boundingBoxes[i] = new BoundingBox((Double)boxProperties.get(0), (Double)boxProperties.get(1), (Double)boxProperties.get(2), (Double)boxProperties.get(3), (Double)boxProperties.get(4), (Double)boxProperties.get(5));
            }
            Arrays.sort(boundingBoxes, Comparator.comparingDouble(BoundingBox::getMiddleY));
            collisions.add(boundingBoxes);
        }
        return collisions;
    }

    public static class CollisionInfo {
        private final CollisionRemapper collisionRemapper;
        private final Pattern pattern;

        public CollisionInfo(CollisionRemapper collisionRemapper, Pattern pattern) {
            this.collisionRemapper = collisionRemapper;
            this.pattern = pattern;
        }
    }
}

