/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakPriority;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakReliability;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.packet.EncapsulatedPacket;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.packet.RakMessage;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.AdvancedChannelInboundHandler;

public class ConnectedPingHandler
extends AdvancedChannelInboundHandler<EncapsulatedPacket> {
    public static final String NAME = "rak-connected-ping-handler";

    @Override
    protected boolean acceptInboundMessage(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!super.acceptInboundMessage(ctx, msg)) {
            return false;
        }
        ByteBuf buf = ((EncapsulatedPacket)((Object)msg)).getBuffer();
        return buf.getUnsignedByte(buf.readerIndex()) == 0;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, EncapsulatedPacket packet) throws Exception {
        ByteBuf buf = packet.getBuffer();
        buf.readUnsignedByte();
        long pingTime = buf.readLong();
        ByteBuf replyBuffer = ctx.alloc().ioBuffer(17);
        replyBuffer.writeByte(3);
        replyBuffer.writeLong(pingTime);
        replyBuffer.writeLong(System.currentTimeMillis());
        ctx.writeAndFlush((Object)new RakMessage(replyBuffer, RakReliability.UNRELIABLE, RakPriority.IMMEDIATE));
    }
}

