/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.util.function.Consumer;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakChannelPipeline;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakServerChannel;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.config.DefaultRakSessionConfig;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.config.RakChannelConfig;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common.ConnectedPingHandler;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common.ConnectedPongHandler;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common.DisconnectNotificationHandler;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common.RakAcknowledgeHandler;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common.RakDatagramCodec;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common.RakSessionCodec;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.common.RakUnhandledMessagesQueue;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.server.RakChildDatagramHandler;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.handler.codec.raknet.server.RakServerOnlineInitialHandler;

public class RakChildChannel
extends AbstractChannel
implements RakChannel {
    private static final ChannelMetadata metadata = new ChannelMetadata(true);
    private final RakChannelConfig config;
    private final InetSocketAddress remoteAddress;
    private final DefaultChannelPipeline rakPipeline;
    private volatile boolean open = true;
    private volatile boolean active;

    RakChildChannel(InetSocketAddress remoteAddress, RakServerChannel parent, long guid, int version, int mtu, Consumer<RakChannel> childConsumer) {
        super((Channel)parent);
        this.remoteAddress = remoteAddress;
        this.config = new DefaultRakSessionConfig(this);
        this.config.setGuid(guid);
        this.config.setProtocolVersion(version);
        this.config.setMtu(mtu);
        if (childConsumer != null) {
            childConsumer.accept(this);
        }
        this.rakPipeline = new RakChannelPipeline(parent, this);
        this.rakPipeline.addLast("rak-child-datagram-handler", (ChannelHandler)new RakChildDatagramHandler(this));
        RakSessionCodec sessionCodec = new RakSessionCodec(this);
        this.rakPipeline.addLast("rak-datagram-codec", (ChannelHandler)new RakDatagramCodec());
        this.rakPipeline.addLast("rak-acknowledge-handler", (ChannelHandler)new RakAcknowledgeHandler(sessionCodec));
        this.rakPipeline.addLast("rak-session-codec", (ChannelHandler)sessionCodec);
        this.rakPipeline.addLast("rak-connected-ping-handler", (ChannelHandler)new ConnectedPingHandler());
        this.rakPipeline.addLast("rak-connected-pong-handler", (ChannelHandler)new ConnectedPongHandler(sessionCodec));
        this.rakPipeline.addLast("rak-disconnect-notification-handler", (ChannelHandler)DisconnectNotificationHandler.INSTANCE);
        this.rakPipeline.addLast("rak-server-online-initial-handler", (ChannelHandler)new RakServerOnlineInitialHandler(this));
        this.rakPipeline.addLast("rak-unhandled-messages-queue", (ChannelHandler)new RakUnhandledMessagesQueue(this));
        this.rakPipeline.fireChannelRegistered();
        this.rakPipeline.fireChannelActive();
    }

    @Override
    public ChannelPipeline rakPipeline() {
        return this.rakPipeline;
    }

    public SocketAddress localAddress0() {
        return this.parent().localAddress();
    }

    public SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public RakChannelConfig config() {
        return this.config;
    }

    public ChannelMetadata metadata() {
        return metadata;
    }

    protected void doBind(SocketAddress socketAddress) throws Exception {
        throw new UnsupportedOperationException("Can not bind child channel!");
    }

    protected void doBeginRead() throws Exception {
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (!this.active) {
            throw new NonWritableChannelException();
        }
        ClosedChannelException exception = null;
        while ((msg = in.current()) != null) {
            try {
                if (this.parent().isOpen()) {
                    this.rakPipeline.write(ReferenceCountUtil.retain((Object)msg));
                    in.remove();
                    continue;
                }
                if (exception == null) {
                    exception = new ClosedChannelException();
                }
                in.remove(exception);
            }
            catch (Throwable cause) {
                in.remove(cause);
            }
        }
        this.rakPipeline.flush();
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    protected void doDisconnect() throws Exception {
        this.close();
    }

    protected void doClose() throws Exception {
        this.open = false;
    }

    public boolean isActive() {
        return this.isOpen() && this.active;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected boolean isCompatible(EventLoop eventLoop) {
        return true;
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new AbstractChannel.AbstractUnsafe(){

            public void connect(SocketAddress socketAddress, SocketAddress socketAddress1, ChannelPromise channelPromise) {
                throw new UnsupportedOperationException("Can not connect child channel!");
            }
        };
    }
}

