/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.lenni0451.lambdaevents.EventHandler;
import net.raphimc.vialegacy.api.LegacyProtocolVersion;
import net.raphimc.viaproxy.ViaProxy;
import net.raphimc.viaproxy.plugins.PluginManager;
import net.raphimc.viaproxy.plugins.ViaProxyPlugin;
import net.raphimc.viaproxy.plugins.events.ConsoleCommandEvent;
import net.raphimc.viaproxy.plugins.events.ProxyStartEvent;
import net.raphimc.viaproxy.plugins.events.ProxyStopEvent;
import net.raphimc.viaproxy.plugins.events.ShouldVerifyOnlineModeEvent;
import org.apache.logging.log4j.LogManager;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommandManager;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.viaproxy.GeyserViaProxyConfiguration;
import org.geysermc.geyser.platform.viaproxy.GeyserViaProxyDumpInfo;
import org.geysermc.geyser.platform.viaproxy.GeyserViaProxyLogger;
import org.geysermc.geyser.platform.viaproxy.listener.GeyserServerTransferListener;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.LoopbackUtil;
import org.jetbrains.annotations.NotNull;

public class GeyserViaProxyPlugin
extends ViaProxyPlugin
implements GeyserBootstrap,
EventRegistrar {
    public static final File ROOT_FOLDER = new File(PluginManager.PLUGINS_DIR, "Geyser");
    private final GeyserViaProxyLogger logger = new GeyserViaProxyLogger(LogManager.getLogger((String)"Geyser"));
    private GeyserViaProxyConfiguration config;
    private GeyserImpl geyser;
    private GeyserCommandManager commandManager;
    private IGeyserPingPassthrough pingPassthrough;

    public void onEnable() {
        ROOT_FOLDER.mkdirs();
        GeyserLocale.init(this);
        this.onGeyserInitialize();
        ViaProxy.EVENT_MANAGER.register((Object)this);
    }

    public void onDisable() {
        this.onGeyserShutdown();
    }

    @EventHandler
    private void onConsoleCommand(ConsoleCommandEvent event) {
        String command;
        String string = command = event.getCommand().startsWith("/") ? event.getCommand().substring(1) : event.getCommand();
        if (this.getGeyserCommandManager().runCommand(this.getGeyserLogger(), command + " " + String.join((CharSequence)" ", event.getArgs()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onShouldVerifyOnlineModeEvent(ShouldVerifyOnlineModeEvent event) {
        UUID uuid = event.getProxyConnection().getGameProfile().getId();
        if (uuid == null) {
            return;
        }
        GeyserSession connection = GeyserImpl.getInstance().onlineConnections().stream().filter(s -> s.javaUuid().equals(uuid)).findAny().orElse(null);
        if (connection == null) {
            return;
        }
        if (connection.javaUsername().equals(event.getProxyConnection().getGameProfile().getName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onProxyStart(ProxyStartEvent event) {
        this.onGeyserEnable();
    }

    @EventHandler
    private void onProxyStop(ProxyStopEvent event) {
        this.onGeyserDisable();
    }

    @Override
    public void onGeyserInitialize() {
        if (!this.loadConfig()) {
            return;
        }
        this.geyser = GeyserImpl.load(PlatformType.VIAPROXY, this);
        this.geyser.eventBus().register(this, new GeyserServerTransferListener());
        LoopbackUtil.checkAndApplyLoopback(this.logger);
    }

    @Override
    public void onGeyserEnable() {
        if (GeyserImpl.getInstance().isReloading() && !this.loadConfig()) {
            return;
        }
        this.commandManager = new GeyserCommandManager(this.geyser);
        this.commandManager.init();
        GeyserImpl.start();
        if (ViaProxy.getConfig().getTargetVersion() != null && ViaProxy.getConfig().getTargetVersion().newerThanOrEqualTo(LegacyProtocolVersion.b1_8tob1_8_1)) {
            this.pingPassthrough = GeyserLegacyPingPassthrough.init(this.geyser);
        }
    }

    @Override
    public void onGeyserDisable() {
        this.geyser.disable();
    }

    @Override
    public void onGeyserShutdown() {
        this.geyser.shutdown();
    }

    @Override
    public GeyserConfiguration getGeyserConfig() {
        return this.config;
    }

    @Override
    public GeyserLogger getGeyserLogger() {
        return this.logger;
    }

    @Override
    public GeyserCommandManager getGeyserCommandManager() {
        return this.commandManager;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.pingPassthrough;
    }

    @Override
    public Path getConfigFolder() {
        return ROOT_FOLDER.toPath();
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserViaProxyDumpInfo();
    }

    @Override
    @NotNull
    public String getServerBindAddress() {
        SocketAddress socketAddress = ViaProxy.getConfig().getBindAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress2 = (InetSocketAddress)socketAddress;
            return socketAddress2.getHostString();
        }
        throw new IllegalStateException("Unsupported bind address type: " + ViaProxy.getConfig().getBindAddress().getClass().getName());
    }

    @Override
    public int getServerPort() {
        SocketAddress socketAddress = ViaProxy.getConfig().getBindAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress2 = (InetSocketAddress)socketAddress;
            return socketAddress2.getPort();
        }
        throw new IllegalStateException("Unsupported bind address type: " + ViaProxy.getConfig().getBindAddress().getClass().getName());
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        return false;
    }

    private boolean loadConfig() {
        try {
            File configFile = FileUtils.fileOrCopiedFromResource(new File(ROOT_FOLDER, "config.yml"), "config.yml", s -> s.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.config = FileUtils.loadConfig(configFile, GeyserViaProxyConfiguration.class);
        }
        catch (IOException e) {
            this.logger.severe(GeyserLocale.getLocaleStringLog("geyser.config.failed"), e);
            return false;
        }
        this.config.getRemote().setAuthType(Files.isRegularFile(this.config.getFloodgateKeyPath(), new LinkOption[0]) ? AuthType.FLOODGATE : AuthType.OFFLINE);
        this.logger.setDebug(this.config.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.config, this.logger);
        return true;
    }
}

