/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import java.util.HashMap;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class GeyserItemStack {
    public static final GeyserItemStack EMPTY = new GeyserItemStack(Items.AIR_ID, 0, null);
    private final int javaId;
    private int amount;
    private DataComponents components;
    private int netId;
    private Item item;

    private GeyserItemStack(int javaId, int amount, DataComponents components) {
        this(javaId, amount, components, 1);
    }

    private GeyserItemStack(int javaId, int amount, DataComponents components, int netId) {
        this.javaId = javaId;
        this.amount = amount;
        this.components = components;
        this.netId = netId;
    }

    public static @NonNull GeyserItemStack of(int javaId, int amount) {
        return GeyserItemStack.of(javaId, amount, null);
    }

    public static @NonNull GeyserItemStack of(int javaId, int amount, @Nullable DataComponents components) {
        return new GeyserItemStack(javaId, amount, components);
    }

    public static @NonNull GeyserItemStack from(@Nullable ItemStack itemStack) {
        return itemStack == null ? EMPTY : new GeyserItemStack(itemStack.getId(), itemStack.getAmount(), itemStack.getDataComponents());
    }

    public int getJavaId() {
        return this.isEmpty() ? 0 : this.javaId;
    }

    public int getAmount() {
        return this.isEmpty() ? 0 : this.amount;
    }

    public @Nullable DataComponents getComponents() {
        return this.isEmpty() ? null : this.components;
    }

    public @NonNull DataComponents getOrCreateComponents() {
        if (this.components == null) {
            this.components = new DataComponents(new HashMap());
            return this.components;
        }
        return this.components;
    }

    public <T> @Nullable T getComponent(@NonNull DataComponentType<T> type) {
        if (this.components == null) {
            return null;
        }
        return this.components.get(type);
    }

    public <T extends Boolean> boolean getComponent(@NonNull DataComponentType<T> type, boolean def) {
        if (this.components == null) {
            return def;
        }
        Boolean result = (Boolean)this.components.get(type);
        if (result != null) {
            return result;
        }
        return def;
    }

    public <T extends Integer> int getComponent(@NonNull DataComponentType<T> type, int def) {
        if (this.components == null) {
            return def;
        }
        Integer result = (Integer)this.components.get(type);
        if (result != null) {
            return result;
        }
        return def;
    }

    public int getNetId() {
        return this.isEmpty() ? 0 : this.netId;
    }

    public void add(int add) {
        this.amount += add;
    }

    public void sub(int sub) {
        this.amount -= sub;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(this.amount);
    }

    public @Nullable ItemStack getItemStack(int newAmount) {
        return this.isEmpty() ? null : new ItemStack(this.javaId, newAmount, this.components);
    }

    public ItemData getItemData(GeyserSession session) {
        if (this.isEmpty()) {
            return ItemData.AIR;
        }
        ItemData.Builder itemData = ItemTranslator.translateToBedrock(session, this.javaId, this.amount, this.components);
        itemData.netId(this.getNetId());
        itemData.usingNetId(true);
        return itemData.build();
    }

    public ItemMapping getMapping(GeyserSession session) {
        return session.getItemMappings().getMapping(this.javaId);
    }

    public Item asItem() {
        if (this.item == null) {
            this.item = (Item)((List)Registries.JAVA_ITEMS.get()).get(this.javaId);
            return this.item;
        }
        return this.item;
    }

    public boolean isEmpty() {
        return this.amount <= 0 || this.javaId == Items.AIR_ID;
    }

    public GeyserItemStack copy() {
        return this.copy(this.amount);
    }

    public GeyserItemStack copy(int newAmount) {
        return this.isEmpty() ? EMPTY : new GeyserItemStack(this.javaId, newAmount, this.components == null ? null : this.components.clone(), this.netId);
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void setComponents(DataComponents components) {
        this.components = components;
    }

    public void setNetId(int netId) {
        this.netId = netId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserItemStack)) {
            return false;
        }
        GeyserItemStack other = (GeyserItemStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getJavaId() != other.getJavaId()) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        if (this.getNetId() != other.getNetId()) {
            return false;
        }
        DataComponents this$components = this.getComponents();
        DataComponents other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeyserItemStack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getJavaId();
        result = result * 59 + this.getAmount();
        result = result * 59 + this.getNetId();
        DataComponents $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    public String toString() {
        return "GeyserItemStack(javaId=" + this.getJavaId() + ", amount=" + this.getAmount() + ", components=" + this.getComponents() + ", netId=" + this.getNetId() + ", item=" + this.item + ")";
    }
}

