/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.dump.DumpInfo;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.AsteriskSerializer;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.WebUtils;

public class DumpCommand
extends GeyserCommand {
    private final GeyserImpl geyser;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String DUMP_URL = "https://dump.geysermc.org/";

    public DumpCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission);
        this.geyser = geyser;
    }

    @Override
    public void execute(GeyserSession session, GeyserCommandSource sender, String[] args) {
        Object uploadedDumpUrl;
        String dumpData;
        if (!sender.isConsole() && this.geyser.getPlatformType() == PlatformType.STANDALONE) {
            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.permission_fail", sender.locale()));
            return;
        }
        boolean showSensitive = false;
        boolean offlineDump = false;
        boolean addLog = false;
        if (args.length >= 1) {
            String[] stringArray = args;
            int n = stringArray.length;
            block16: for (int i = 0; i < n; ++i) {
                String arg;
                switch (arg = stringArray[i]) {
                    case "full": {
                        showSensitive = true;
                        continue block16;
                    }
                    case "offline": {
                        offlineDump = true;
                        continue block16;
                    }
                    case "logs": {
                        addLog = true;
                    }
                }
            }
        }
        AsteriskSerializer.showSensitive = showSensitive;
        sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.dump.collecting", sender.locale()));
        try {
            if (offlineDump) {
                DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
                prettyPrinter.indentArraysWith(new DefaultIndenter("    ", "\n"));
                dumpData = MAPPER.writer(prettyPrinter).writeValueAsString(new DumpInfo(addLog));
            } else {
                dumpData = MAPPER.writeValueAsString(new DumpInfo(addLog));
            }
        }
        catch (IOException e) {
            sender.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.dump.collect_error", sender.locale()));
            this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.dump.collect_error_short"), e);
            return;
        }
        if (offlineDump) {
            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.dump.writing", sender.locale()));
            try {
                FileOutputStream outputStream = new FileOutputStream(GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("dump.json").toFile());
                outputStream.write(dumpData.getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                sender.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.dump.write_error", sender.locale()));
                this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.dump.write_error_short"), e);
                return;
            }
            uploadedDumpUrl = "dump.json";
        } else {
            JsonNode responseNode;
            String response;
            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.dump.uploading", sender.locale()));
            try {
                response = WebUtils.post("https://dump.geysermc.org/documents", dumpData);
                responseNode = MAPPER.readTree(response);
            }
            catch (IOException e) {
                sender.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.dump.upload_error", sender.locale()));
                this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.dump.upload_error_short"), e);
                return;
            }
            if (!responseNode.has("key")) {
                sender.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.dump.upload_error_short", sender.locale()) + ": " + (responseNode.has("message") ? responseNode.get("message").asText() : response));
                return;
            }
            uploadedDumpUrl = DUMP_URL + responseNode.get("key").asText();
        }
        sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.dump.message", sender.locale()) + " \u00a73" + (String)uploadedDumpUrl);
        if (!sender.isConsole()) {
            this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.commands.dump.created", sender.name(), uploadedDumpUrl));
        }
    }

    @Override
    public @NonNull List<String> subCommands() {
        return Arrays.asList("offline", "full", "logs");
    }

    @Override
    public boolean isSuggestedOpOnly() {
        return true;
    }
}

