/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.codec.v361.serializer;

import io.netty.buffer.ByteBuf;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.v332.serializer.StartGameSerializer_v332;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition;
import org.cloudburstmc.protocol.bedrock.packet.StartGamePacket;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class StartGameSerializer_v361
extends StartGameSerializer_v332 {
    public static final StartGameSerializer_v361 INSTANCE = new StartGameSerializer_v361();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, StartGamePacket packet) {
        VarInts.writeLong(buffer, packet.getUniqueEntityId());
        VarInts.writeUnsignedLong(buffer, packet.getRuntimeEntityId());
        VarInts.writeInt(buffer, packet.getPlayerGameType().ordinal());
        helper.writeVector3f(buffer, packet.getPlayerPosition());
        helper.writeVector2f(buffer, packet.getRotation());
        this.writeLevelSettings(buffer, helper, packet);
        helper.writeString(buffer, packet.getLevelId());
        helper.writeString(buffer, packet.getLevelName());
        helper.writeString(buffer, packet.getPremiumWorldTemplateId());
        buffer.writeBoolean(packet.isTrial());
        buffer.writeLongLE(packet.getCurrentTick());
        VarInts.writeInt(buffer, packet.getEnchantmentSeed());
        NbtList<NbtMap> palette = packet.getBlockPalette();
        VarInts.writeUnsignedInt(buffer, palette.size());
        for (NbtMap entry2 : palette) {
            NbtMap blockTag = entry2.getCompound("block");
            helper.writeString(buffer, blockTag.getString("name"));
            buffer.writeShortLE((int)entry2.getShort("meta"));
            buffer.writeShortLE((int)entry2.getShort("id"));
        }
        helper.writeArray(buffer, packet.getItemDefinitions(), (buf, entry) -> {
            helper.writeString((ByteBuf)buf, entry.getIdentifier());
            buf.writeShortLE(entry.getRuntimeId());
        });
        helper.writeString(buffer, packet.getMultiplayerCorrelationId());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, StartGamePacket packet) {
        packet.setUniqueEntityId(VarInts.readLong(buffer));
        packet.setRuntimeEntityId(VarInts.readUnsignedLong(buffer));
        packet.setPlayerGameType(GameType.from(VarInts.readInt(buffer)));
        packet.setPlayerPosition(helper.readVector3f(buffer));
        packet.setRotation(helper.readVector2f(buffer));
        this.readLevelSettings(buffer, helper, packet);
        packet.setLevelId(helper.readString(buffer));
        packet.setLevelName(helper.readString(buffer));
        packet.setPremiumWorldTemplateId(helper.readString(buffer));
        packet.setTrial(buffer.readBoolean());
        packet.setCurrentTick(buffer.readLongLE());
        packet.setEnchantmentSeed(VarInts.readInt(buffer));
        int paletteLength = VarInts.readUnsignedInt(buffer);
        ObjectArrayList palette = new ObjectArrayList(paletteLength);
        for (int i = 0; i < paletteLength; ++i) {
            palette.add(NbtMap.builder().putCompound("block", NbtMap.builder().putString("name", helper.readString(buffer)).build()).putShort("meta", buffer.readShortLE()).putShort("id", buffer.readShortLE()).build());
        }
        packet.setBlockPalette(new NbtList<NbtMap>(NbtType.COMPOUND, palette));
        helper.readArray(buffer, packet.getItemDefinitions(), (buf, packetHelper) -> {
            String identifier = packetHelper.readString((ByteBuf)buf);
            short id = buf.readShortLE();
            return new SimpleItemDefinition(identifier, id, false);
        });
        packet.setMultiplayerCorrelationId(helper.readString(buffer));
    }

    @Override
    protected void readLevelSettings(ByteBuf buffer, BedrockCodecHelper helper, StartGamePacket packet) {
        super.readLevelSettings(buffer, helper, packet);
        packet.setOnlySpawningV1Villagers(buffer.readBoolean());
    }

    @Override
    protected void writeLevelSettings(ByteBuf buffer, BedrockCodecHelper helper, StartGamePacket packet) {
        super.writeLevelSettings(buffer, helper, packet);
        buffer.writeBoolean(packet.isOnlySpawningV1Villagers());
    }

    protected StartGameSerializer_v361() {
    }
}

