/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.ChunkBiomeData;

public class ClientboundChunksBiomesPacket
implements MinecraftPacket {
    private final List<ChunkBiomeData> chunkBiomeData;

    public ClientboundChunksBiomesPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.chunkBiomeData = helper.readList(in, buf -> {
            long raw = buf.readLong();
            return new ChunkBiomeData((int)raw, (int)(raw >> 32), helper.readByteArray((ByteBuf)buf));
        });
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeList(out, this.chunkBiomeData, (buf, entry) -> {
            long raw = (long)entry.getX() & 0xFFFFFFFFL | ((long)entry.getZ() & 0xFFFFFFFFL) << 32;
            buf.writeLong(raw);
            helper.writeByteArray((ByteBuf)buf, entry.getBuffer());
        });
    }

    public List<ChunkBiomeData> getChunkBiomeData() {
        return this.chunkBiomeData;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundChunksBiomesPacket)) {
            return false;
        }
        ClientboundChunksBiomesPacket other = (ClientboundChunksBiomesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ChunkBiomeData> this$chunkBiomeData = this.getChunkBiomeData();
        List<ChunkBiomeData> other$chunkBiomeData = other.getChunkBiomeData();
        return !(this$chunkBiomeData == null ? other$chunkBiomeData != null : !((Object)this$chunkBiomeData).equals(other$chunkBiomeData));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundChunksBiomesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ChunkBiomeData> $chunkBiomeData = this.getChunkBiomeData();
        result = result * 59 + ($chunkBiomeData == null ? 43 : ((Object)$chunkBiomeData).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundChunksBiomesPacket(chunkBiomeData=" + this.getChunkBiomeData() + ")";
    }

    public ClientboundChunksBiomesPacket(List<ChunkBiomeData> chunkBiomeData) {
        this.chunkBiomeData = chunkBiomeData;
    }
}

