/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundMoveVehiclePacket
implements MinecraftPacket {
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;

    public ClientboundMoveVehiclePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundMoveVehiclePacket)) {
            return false;
        }
        ClientboundMoveVehiclePacket other = (ClientboundMoveVehiclePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        return Float.compare(this.getPitch(), other.getPitch()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundMoveVehiclePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundMoveVehiclePacket(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public @NonNull ClientboundMoveVehiclePacket withX(double x) {
        return this.x == x ? this : new ClientboundMoveVehiclePacket(x, this.y, this.z, this.yaw, this.pitch);
    }

    public @NonNull ClientboundMoveVehiclePacket withY(double y) {
        return this.y == y ? this : new ClientboundMoveVehiclePacket(this.x, y, this.z, this.yaw, this.pitch);
    }

    public @NonNull ClientboundMoveVehiclePacket withZ(double z) {
        return this.z == z ? this : new ClientboundMoveVehiclePacket(this.x, this.y, z, this.yaw, this.pitch);
    }

    public @NonNull ClientboundMoveVehiclePacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ClientboundMoveVehiclePacket(this.x, this.y, this.z, yaw, this.pitch);
    }

    public @NonNull ClientboundMoveVehiclePacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundMoveVehiclePacket(this.x, this.y, this.z, this.yaw, pitch);
    }

    public ClientboundMoveVehiclePacket(double x, double y, double z, float yaw, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }
}

