/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.attribute;

import net.kyori.adventure.key.Key;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public interface AttributeType {
    public Key getIdentifier();

    public int getId();

    public static enum Builtin implements AttributeType
    {
        GENERIC_ARMOR("minecraft:generic.armor", 0.0, 0.0, 30.0),
        GENERIC_ARMOR_TOUGHNESS("minecraft:generic.armor_toughness", 0.0, 0.0, 20.0),
        GENERIC_ATTACK_DAMAGE("minecraft:generic.attack_damage", 2.0, 0.0, 2048.0),
        GENERIC_ATTACK_KNOCKBACK("minecraft:generic.attack_knockback", 0.0, 0.0, 5.0),
        GENERIC_ATTACK_SPEED("minecraft:generic.attack_speed", 4.0, 0.0, 1024.0),
        PLAYER_BLOCK_BREAK_SPEED("minecraft:player.block_break_speed", 1.0, 0.0, 1024.0),
        PLAYER_BLOCK_INTERACTION_RANGE("minecraft:player.block_interaction_range", 4.5, 0.0, 64.0),
        GENERIC_BURNING_TIME("minecraft:generic.burning_time", 1.0, 0.0, 1024.0),
        GENERIC_EXPLOSION_KNOCKBACK_RESISTANCE("minecraft:generic.explosion_knockback_resistance", 0.0, 0.0, 1.0),
        PLAYER_ENTITY_INTERACTION_RANGE("minecraft:player.entity_interaction_range", 3.0, 0.0, 64.0),
        GENERIC_FALL_DAMAGE_MULTIPLIER("minecraft:generic.fall_damage_multiplier", 1.0, 0.0, 100.0),
        GENERIC_FLYING_SPEED("minecraft:generic.flying_speed", 0.4, 0.0, 1024.0),
        GENERIC_FOLLOW_RANGE("minecraft:generic.follow_range", 32.0, 0.0, 2048.0),
        GENERIC_GRAVITY("minecraft:generic.gravity", 0.08, -1.0, 1.0),
        GENERIC_JUMP_STRENGTH("minecraft:generic.jump_strength", 0.42, 0.0, 32.0),
        GENERIC_KNOCKBACK_RESISTANCE("minecraft:generic.knockback_resistance", 0.0, 0.0, 1.0),
        GENERIC_LUCK("minecraft:generic.luck", 0.0, -1024.0, 1024.0),
        GENERIC_MAX_ABSORPTION("minecraft:generic.max_absorption", 0.0, 0.0, 2048.0),
        GENERIC_MAX_HEALTH("minecraft:generic.max_health", 20.0, 1.0, 1024.0),
        PLAYER_MINING_EFFICIENCY("minecraft:player.mining_efficiency", 0.0, 0.0, 1024.0),
        GENERIC_MOVEMENT_EFFICIENCY("minecraft:generic.movement_efficiency", 0.0, 0.0, 1.0),
        GENERIC_MOVEMENT_SPEED("minecraft:generic.movement_speed", 0.7, 0.0, 1024.0),
        GENERIC_OXYGEN_BONUS("minecraft:generic.oxygen_bonus", 0.0, 0.0, 1024.0),
        GENERIC_SAFE_FALL_DISTANCE("minecraft:generic.safe_fall_distance", 3.0, -1024.0, 1024.0),
        GENERIC_SCALE("minecraft:generic.scale", 1.0, 0.0625, 16.0),
        PLAYER_SNEAKING_SPEED("minecraft:player.sneaking_speed", 0.3, 0.0, 1.0),
        ZOMBIE_SPAWN_REINFORCEMENTS("minecraft:zombie.spawn_reinforcements", 0.0, 0.0, 1.0),
        GENERIC_STEP_HEIGHT("minecraft:generic.step_height", 0.6, 0.0, 10.0),
        PLAYER_SUBMERGED_MINING_SPEED("minecraft:player.submerged_mining_speed", 0.2, 0.0, 20.0),
        PLAYER_SWEEPING_DAMAGE_RATIO("minecraft:player.sweeping_damage_ratio", 0.0, 0.0, 1.0),
        GENERIC_WATER_MOVEMENT_EFFICIENCY("minecraft:generic.water_movement_efficiency", 0.0, 0.0, 1.0);

        private final Key identifier;
        private final double def;
        private final double min;
        private final double max;
        public static final Int2ObjectMap<AttributeType> BUILTIN;

        private Builtin(String identifier, double def, double min, double max) {
            this.identifier = Key.key(identifier);
            this.def = def;
            this.min = min;
            this.max = max;
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        public static AttributeType from(int id) {
            return (AttributeType)BUILTIN.get(id);
        }

        @Override
        public Key getIdentifier() {
            return this.identifier;
        }

        public double getDef() {
            return this.def;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        static {
            BUILTIN = new Int2ObjectOpenHashMap<AttributeType>();
            for (Builtin attribute : Builtin.values()) {
                BUILTIN.put(attribute.ordinal(), (AttributeType)attribute);
            }
        }
    }
}

