/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.auth.SessionService;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.event.session.ConnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.SessionAdapter;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.network.tcp.TcpClientSession;
import org.geysermc.mcprotocollib.protocol.MinecraftConstants;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;
import org.geysermc.mcprotocollib.protocol.data.UnexpectedEncryptionException;
import org.geysermc.mcprotocollib.protocol.data.handshake.HandshakeIntent;
import org.geysermc.mcprotocollib.protocol.data.status.ServerStatusInfo;
import org.geysermc.mcprotocollib.protocol.data.status.handler.ServerInfoHandler;
import org.geysermc.mcprotocollib.protocol.data.status.handler.ServerPingTimeHandler;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundDisconnectPacket;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundKeepAlivePacket;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundTransferPacket;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundKeepAlivePacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundSelectKnownPacks;
import org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound.ServerboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound.ServerboundSelectKnownPacks;
import org.geysermc.mcprotocollib.protocol.packet.handshake.serverbound.ClientIntentionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundStartConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundConfigurationAcknowledgedPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundGameProfilePacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundHelloPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginCompressionPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginDisconnectPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundHelloPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundKeyPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundLoginAcknowledgedPacket;
import org.geysermc.mcprotocollib.protocol.packet.status.clientbound.ClientboundPongResponsePacket;
import org.geysermc.mcprotocollib.protocol.packet.status.clientbound.ClientboundStatusResponsePacket;
import org.geysermc.mcprotocollib.protocol.packet.status.serverbound.ServerboundPingRequestPacket;
import org.geysermc.mcprotocollib.protocol.packet.status.serverbound.ServerboundStatusRequestPacket;

public class ClientListener
extends SessionAdapter {
    @NonNull
    private final ProtocolState targetState;
    private final boolean transferring;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void packetReceived(Session session, Packet packet) {
        MinecraftProtocol protocol = (MinecraftProtocol)session.getPacketProtocol();
        if (protocol.getState() == ProtocolState.LOGIN) {
            if (packet instanceof ClientboundHelloPacket) {
                SecretKey key;
                ClientboundHelloPacket helloPacket = (ClientboundHelloPacket)packet;
                GameProfile profile = session.getFlag(MinecraftConstants.PROFILE_KEY);
                String accessToken = session.getFlag(MinecraftConstants.ACCESS_TOKEN_KEY);
                if (profile == null) throw new UnexpectedEncryptionException();
                if (accessToken == null) {
                    throw new UnexpectedEncryptionException();
                }
                try {
                    KeyGenerator gen = KeyGenerator.getInstance("AES");
                    gen.init(128);
                    key = gen.generateKey();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Failed to generate shared key.", e);
                }
                SessionService sessionService = session.getFlag(MinecraftConstants.SESSION_SERVICE_KEY, new SessionService());
                String serverId = SessionService.getServerId(helloPacket.getServerId(), helloPacket.getPublicKey(), key);
                try {
                    sessionService.joinServer(profile, accessToken, serverId);
                }
                catch (IOException e) {
                    session.disconnect((Component)Component.translatable((String)"disconnect.loginFailedInfo", (ComponentLike[])new ComponentLike[]{Component.text((String)e.getMessage())}), (Throwable)e);
                    return;
                }
                session.send(new ServerboundKeyPacket(helloPacket.getPublicKey(), key, helloPacket.getChallenge()));
                session.enableEncryption(protocol.enableEncryption(key));
                return;
            }
            if (packet instanceof ClientboundGameProfilePacket) {
                session.send(new ServerboundLoginAcknowledgedPacket());
                return;
            }
            if (packet instanceof ClientboundLoginDisconnectPacket) {
                ClientboundLoginDisconnectPacket loginDisconnectPacket = (ClientboundLoginDisconnectPacket)packet;
                session.disconnect(loginDisconnectPacket.getReason());
                return;
            }
            if (!(packet instanceof ClientboundLoginCompressionPacket)) return;
            ClientboundLoginCompressionPacket loginCompressionPacket = (ClientboundLoginCompressionPacket)packet;
            session.setCompressionThreshold(loginCompressionPacket.getThreshold(), false);
            return;
        }
        if (protocol.getState() == ProtocolState.STATUS) {
            if (packet instanceof ClientboundStatusResponsePacket) {
                ClientboundStatusResponsePacket statusResponsePacket = (ClientboundStatusResponsePacket)packet;
                ServerStatusInfo info = statusResponsePacket.parseInfo();
                ServerInfoHandler handler = session.getFlag(MinecraftConstants.SERVER_INFO_HANDLER_KEY);
                if (handler != null) {
                    handler.handle(session, info);
                }
                session.send(new ServerboundPingRequestPacket(System.currentTimeMillis()));
                return;
            }
            if (!(packet instanceof ClientboundPongResponsePacket)) return;
            ClientboundPongResponsePacket pongResponsePacket = (ClientboundPongResponsePacket)packet;
            long time = System.currentTimeMillis() - pongResponsePacket.getPingTime();
            ServerPingTimeHandler handler = session.getFlag(MinecraftConstants.SERVER_PING_TIME_HANDLER_KEY);
            if (handler != null) {
                handler.handle(session, time);
            }
            session.disconnect((Component)Component.translatable((String)"multiplayer.status.finished"));
            return;
        }
        if (protocol.getState() == ProtocolState.GAME) {
            if (packet instanceof ClientboundKeepAlivePacket) {
                ClientboundKeepAlivePacket keepAlivePacket = (ClientboundKeepAlivePacket)packet;
                if (session.getFlag(MinecraftConstants.AUTOMATIC_KEEP_ALIVE_MANAGEMENT, true).booleanValue()) {
                    session.send(new ServerboundKeepAlivePacket(keepAlivePacket.getPingId()));
                    return;
                }
            }
            if (packet instanceof ClientboundDisconnectPacket) {
                ClientboundDisconnectPacket disconnectPacket = (ClientboundDisconnectPacket)packet;
                session.disconnect(disconnectPacket.getReason());
                return;
            }
            if (packet instanceof ClientboundStartConfigurationPacket) {
                session.send(new ServerboundConfigurationAcknowledgedPacket());
                return;
            }
            if (!(packet instanceof ClientboundTransferPacket)) return;
            ClientboundTransferPacket transferPacket = (ClientboundTransferPacket)packet;
            if (session.getFlag(MinecraftConstants.FOLLOW_TRANSFERS, true) == false) return;
            TcpClientSession newSession = new TcpClientSession(transferPacket.getHost(), transferPacket.getPort(), session.getPacketProtocol());
            newSession.setFlags(session.getFlags());
            session.disconnect((Component)Component.translatable((String)"disconnect.transfer"));
            newSession.connect(true, true);
            return;
        }
        if (protocol.getState() != ProtocolState.CONFIGURATION) return;
        if (packet instanceof ClientboundFinishConfigurationPacket) {
            session.send(new ServerboundFinishConfigurationPacket());
            return;
        }
        if (packet instanceof ClientboundSelectKnownPacks) {
            if (session.getFlag(MinecraftConstants.SEND_BLANK_KNOWN_PACKS_RESPONSE, true) == false) return;
            session.send(new ServerboundSelectKnownPacks(Collections.emptyList()));
            return;
        }
        if (!(packet instanceof ClientboundTransferPacket)) return;
        ClientboundTransferPacket transferPacket = (ClientboundTransferPacket)packet;
        if (session.getFlag(MinecraftConstants.FOLLOW_TRANSFERS, true) == false) return;
        TcpClientSession newSession = new TcpClientSession(transferPacket.getHost(), transferPacket.getPort(), session.getPacketProtocol());
        newSession.setFlags(session.getFlags());
        session.disconnect((Component)Component.translatable((String)"disconnect.transfer"));
        newSession.connect(true, true);
        return;
    }

    @Override
    public void packetSent(Session session, Packet packet) {
        MinecraftProtocol protocol = (MinecraftProtocol)session.getPacketProtocol();
        if (packet instanceof ClientIntentionPacket) {
            protocol.setState(this.targetState);
            if (this.targetState == ProtocolState.LOGIN) {
                GameProfile profile = session.getFlag(MinecraftConstants.PROFILE_KEY);
                session.send(new ServerboundHelloPacket(profile.getName(), profile.getId()));
            } else {
                session.send(new ServerboundStatusRequestPacket());
            }
        } else if (packet instanceof ServerboundLoginAcknowledgedPacket) {
            protocol.setState(ProtocolState.CONFIGURATION);
        } else if (packet instanceof ServerboundFinishConfigurationPacket) {
            protocol.setState(ProtocolState.GAME);
        } else if (packet instanceof ServerboundConfigurationAcknowledgedPacket) {
            protocol.setState(ProtocolState.CONFIGURATION);
        }
    }

    @Override
    public void connected(ConnectedEvent event) {
        MinecraftProtocol protocol = (MinecraftProtocol)event.getSession().getPacketProtocol();
        if (this.targetState == ProtocolState.LOGIN) {
            if (this.transferring) {
                event.getSession().send(new ClientIntentionPacket(protocol.getCodec().getProtocolVersion(), event.getSession().getHost(), event.getSession().getPort(), HandshakeIntent.TRANSFER));
            } else {
                event.getSession().send(new ClientIntentionPacket(protocol.getCodec().getProtocolVersion(), event.getSession().getHost(), event.getSession().getPort(), HandshakeIntent.LOGIN));
            }
        } else if (this.targetState == ProtocolState.STATUS) {
            event.getSession().send(new ClientIntentionPacket(protocol.getCodec().getProtocolVersion(), event.getSession().getHost(), event.getSession().getPort(), HandshakeIntent.STATUS));
        }
    }

    public ClientListener(@NonNull ProtocolState targetState, boolean transferring) {
        if (targetState == null) {
            throw new NullPointerException("targetState is marked non-null but is null");
        }
        this.targetState = targetState;
        this.transferring = transferring;
    }
}

