/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.annotation.JsonSetter;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.annotation.Nulls;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

public class FileUtils {
    public static <T> T loadConfig(File src, Class<T> valueType) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).setDefaultSetterInfo(JsonSetter.Value.forValueNulls(Nulls.AS_EMPTY));
        return objectMapper.readValue(src, valueType);
    }

    public static <T> T loadJson(InputStream src, Class<T> valueType) throws IOException {
        return GeyserImpl.JSON_MAPPER.readValue((Reader)new InputStreamReader(src, StandardCharsets.UTF_8), valueType);
    }

    public static File fileOrCopiedFromResource(File file, String name, Function<String, String> format, GeyserBootstrap bootstrap) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(file);
                 InputStream input = bootstrap.getResourceOrThrow(name);){
                byte[] bytes = new byte[input.available()];
                input.read(bytes);
                for (char c : format.apply(new String(bytes)).toCharArray()) {
                    fos.write(c);
                }
                fos.flush();
            }
        }
        return file;
    }

    public static void writeFile(File file, char[] data) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            for (char c : data) {
                fos.write(c);
            }
            fos.flush();
        }
    }

    public static void writeFile(String name, char[] data) throws IOException {
        FileUtils.writeFile(new File(name), data);
    }

    public static byte[] calculateSHA256(Path path) {
        byte[] sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256").digest(Files.readAllBytes(path));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not calculate pack hash", e);
        }
        return sha256;
    }

    public static byte[] calculateSHA1(Path path) {
        byte[] sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA-1").digest(Files.readAllBytes(path));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not calculate pack hash", e);
        }
        return sha1;
    }

    public static byte[] readAllBytes(String resource) {
        byte[] byArray;
        block8: {
            InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(resource);
            try {
                byArray = stream.readAllBytes();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while trying to read internal input stream!", e);
                }
            }
            stream.close();
        }
        return byArray;
    }

    public static String readToString(String resource) {
        return new String(FileUtils.readAllBytes(resource), StandardCharsets.UTF_8);
    }

    public static Stream<String> readAllLines(Path path) {
        try {
            return new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]))).lines();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while trying to read file!", e);
        }
    }

    public static Set<Class<?>> getGeneratedClassesForAnnotation(Class<? extends Annotation> annotationClass) {
        return FileUtils.getGeneratedClassesForAnnotation(annotationClass.getName());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Set<Class<?>> getGeneratedClassesForAnnotation(String input) {
        try (InputStream annotatedClass = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(input);){
            Set<Class<?>> set;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(annotatedClass));){
                set = reader.lines().map(className -> {
                    try {
                        return Class.forName(className);
                    }
                    catch (ClassNotFoundException ex) {
                        GeyserImpl.getInstance().getLogger().error("Failed to find class " + className, ex);
                        throw new RuntimeException(ex);
                    }
                }).collect(Collectors.toSet());
            }
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

