/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.text;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.text.renderer.TranslatableComponentRenderer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.json.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.legacy.CharacterAndFormat;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.packet.TextPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.DummyLegacyHoverEventSerializer;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.GsonComponentSerializerWrapper;
import org.geysermc.geyser.text.MinecraftTranslationRegistry;
import org.geysermc.geyser.text.TextDecoration;
import org.geysermc.mcprotocollib.protocol.data.DefaultComponentSerializer;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatType;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatTypeDecoration;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.TeamColor;

public class MessageTranslator {
    private static final TranslatableComponentRenderer<String> RENDERER = new MinecraftTranslationRegistry();
    private static final GsonComponentSerializer GSON_SERIALIZER;
    private static final LegacyComponentSerializer BEDROCK_SERIALIZER;
    private static final String BEDROCK_COLORS;
    private static final Map<TeamColor, String> TEAM_COLORS;
    private static final String BASE = "\u00a7";
    private static final String RESET = "\u00a7r";

    public static String convertMessage(Component message, String locale) {
        try {
            message = RENDERER.render(message, (Object)locale);
            String legacy = BEDROCK_SERIALIZER.serialize(message);
            StringBuilder finalLegacy = new StringBuilder();
            char[] legacyChars = legacy.toCharArray();
            boolean lastFormatReset = false;
            for (int i = 0; i < legacyChars.length; ++i) {
                char next;
                char legacyChar = legacyChars[i];
                if (legacyChar != '\u00a7' || i >= legacyChars.length - 1) {
                    finalLegacy.append(legacyChar);
                    lastFormatReset = false;
                    continue;
                }
                if (BEDROCK_COLORS.indexOf(next = legacyChars[++i]) != -1 && !lastFormatReset) {
                    finalLegacy.append(RESET);
                }
                finalLegacy.append(BASE).append(next);
                lastFormatReset = next == 'r';
            }
            return finalLegacy.toString();
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().debug((String)GSON_SERIALIZER.serialize(message));
            GeyserImpl.getInstance().getLogger().error("Failed to parse message", e);
            return "";
        }
    }

    public static String convertJsonMessage(GeyserSession session, String message) {
        return MessageTranslator.convertJsonMessage(message, session.locale());
    }

    public static String convertJsonMessage(String message, String locale) {
        return MessageTranslator.convertMessage(GSON_SERIALIZER.deserialize((Object)message), locale);
    }

    public static String convertMessage(GeyserSession session, Component message) {
        return MessageTranslator.convertMessage(message, session.locale());
    }

    public static String convertMessage(Component message) {
        return MessageTranslator.convertMessage(message, GeyserLocale.getDefaultLocale());
    }

    public static String convertMessageLenient(String message, String locale) {
        if (message == null) {
            return "";
        }
        if (message.isBlank()) {
            return message;
        }
        try {
            return MessageTranslator.convertJsonMessage(message, locale);
        }
        catch (Exception ignored) {
            Object convertedMessage = MessageTranslator.convertMessage((Component)LegacyComponentSerializer.legacySection().deserialize(message), locale);
            if (message.startsWith(RESET) && !((String)convertedMessage).startsWith(RESET)) {
                convertedMessage = RESET + (String)convertedMessage;
            }
            return convertedMessage;
        }
    }

    public static String convertMessageLenient(String message) {
        return MessageTranslator.convertMessageLenient(message, GeyserLocale.getDefaultLocale());
    }

    public static String convertToJavaMessage(String message) {
        TextComponent component = BEDROCK_SERIALIZER.deserialize(message);
        return (String)GSON_SERIALIZER.serialize((Component)component);
    }

    public static String convertToPlainText(Component message, String locale) {
        if (message == null) {
            return "";
        }
        return PlainTextComponentSerializer.plainText().serialize(RENDERER.render(message, (Object)locale));
    }

    public static String convertToPlainText(String message) {
        char[] input = message.toCharArray();
        char[] output = new char[input.length];
        int outputSize = 0;
        int inputLength = input.length;
        for (int i = 0; i < inputLength; ++i) {
            char c = input[i];
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            output[outputSize++] = c;
        }
        return new String(output, 0, outputSize);
    }

    public static String convertToPlainTextLenient(String message, String locale) {
        if (message == null) {
            return "";
        }
        TextComponent messageComponent = null;
        if (message.startsWith("{") && message.endsWith("}")) {
            try {
                messageComponent = GSON_SERIALIZER.deserialize((Object)message);
                messageComponent = RENDERER.render((Component)messageComponent, (Object)locale);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (messageComponent == null) {
            messageComponent = LegacyComponentSerializer.legacySection().deserialize(message);
        }
        return PlainTextComponentSerializer.plainText().serialize((Component)messageComponent);
    }

    public static void handleChatPacket(GeyserSession session, Component message, Holder<ChatType> chatTypeHolder, Component targetName, Component sender) {
        TextPacket textPacket = new TextPacket();
        textPacket.setPlatformChatId("");
        textPacket.setSourceName("");
        textPacket.setXuid(session.getAuthData().xuid());
        textPacket.setType(TextPacket.Type.CHAT);
        textPacket.setNeedsTranslation(false);
        ChatType chatType = chatTypeHolder.getOrCompute(session.getRegistryCache().chatTypes()::byId);
        if (chatType != null && chatType.chat() != null) {
            ChatTypeDecoration chat = chatType.chat();
            TranslatableComponent.Builder withDecoration = (TranslatableComponent.Builder)Component.translatable().key(chat.translationKey()).style(TextDecoration.getStyle(chat));
            List<ChatTypeDecoration.Parameter> parameters = chat.parameters();
            ArrayList<Component> args = new ArrayList<Component>(3);
            if (parameters.contains((Object)ChatTypeDecoration.Parameter.TARGET)) {
                args.add(targetName);
            }
            if (parameters.contains((Object)ChatTypeDecoration.Parameter.SENDER)) {
                args.add(sender);
            }
            if (parameters.contains((Object)ChatTypeDecoration.Parameter.CONTENT)) {
                args.add(message);
            }
            withDecoration.arguments(args);
            textPacket.setMessage(MessageTranslator.convertMessage((Component)withDecoration.build(), session.locale()));
        } else {
            session.getGeyser().getLogger().debug("Likely illegal chat type detection found.");
            if (session.getGeyser().getConfig().isDebugMode()) {
                Thread.dumpStack();
            }
            textPacket.setMessage(MessageTranslator.convertMessage(message, session.locale()));
        }
        session.sendUpstreamPacket(textPacket);
    }

    public static String toChatColor(TeamColor teamColor) {
        return TEAM_COLORS.getOrDefault((Object)teamColor, "");
    }

    public static boolean isTooLong(String message, GeyserSession session) {
        if (message.length() > 256) {
            session.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.chat.too_long", session.locale(), message.length()));
            return true;
        }
        return false;
    }

    public static String normalizeSpace(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        int size = string.length();
        char[] newChars = new char[size];
        int count = 0;
        int whitespacesCount = 0;
        boolean startWhitespaces = true;
        for (int i = 0; i < size; ++i) {
            char actualChar = string.charAt(i);
            boolean isWhitespace = Character.isWhitespace(actualChar);
            if (isWhitespace) {
                if (whitespacesCount == 0 && !startWhitespaces) {
                    newChars[count++] = 32;
                }
                ++whitespacesCount;
                continue;
            }
            startWhitespaces = false;
            newChars[count++] = actualChar == '\u00a0' ? 32 : (int)actualChar;
            whitespacesCount = 0;
        }
        if (startWhitespaces) {
            return "";
        }
        return new String(newChars, 0, count - (whitespacesCount > 0 ? 1 : 0)).trim();
    }

    public static String deserializeDescription(NbtMap tag) {
        NbtMap description = tag.getCompound("description");
        String translate = description.getString("translate", null);
        if (translate == null) {
            GeyserImpl.getInstance().getLogger().debug("Don't know how to read description! " + tag);
            return "";
        }
        return translate;
    }

    public static void init() {
    }

    static {
        TEAM_COLORS = new EnumMap<TeamColor, String>(TeamColor.class);
        TEAM_COLORS.put(TeamColor.RESET, RESET);
        TEAM_COLORS.put(TeamColor.BLACK, "\u00a70");
        TEAM_COLORS.put(TeamColor.DARK_BLUE, "\u00a71");
        TEAM_COLORS.put(TeamColor.DARK_GREEN, "\u00a72");
        TEAM_COLORS.put(TeamColor.DARK_AQUA, "\u00a73");
        TEAM_COLORS.put(TeamColor.DARK_RED, "\u00a74");
        TEAM_COLORS.put(TeamColor.DARK_PURPLE, "\u00a75");
        TEAM_COLORS.put(TeamColor.GOLD, "\u00a76");
        TEAM_COLORS.put(TeamColor.GRAY, "\u00a77");
        TEAM_COLORS.put(TeamColor.DARK_GRAY, "\u00a78");
        TEAM_COLORS.put(TeamColor.BLUE, "\u00a79");
        TEAM_COLORS.put(TeamColor.GREEN, "\u00a7a");
        TEAM_COLORS.put(TeamColor.AQUA, "\u00a7b");
        TEAM_COLORS.put(TeamColor.RED, "\u00a7c");
        TEAM_COLORS.put(TeamColor.LIGHT_PURPLE, "\u00a7d");
        TEAM_COLORS.put(TeamColor.YELLOW, "\u00a7e");
        TEAM_COLORS.put(TeamColor.WHITE, "\u00a7f");
        TEAM_COLORS.put(TeamColor.OBFUSCATED, "\u00a7k");
        TEAM_COLORS.put(TeamColor.BOLD, "\u00a7l");
        TEAM_COLORS.put(TeamColor.STRIKETHROUGH, "\u00a7m");
        TEAM_COLORS.put(TeamColor.ITALIC, "\u00a7o");
        GsonComponentSerializer source = ((GsonComponentSerializer.Builder)DefaultComponentSerializer.get().toBuilder()).legacyHoverEventSerializer((LegacyHoverEventSerializer)new DummyLegacyHoverEventSerializer()).build();
        GSON_SERIALIZER = new GsonComponentSerializerWrapper(source);
        DefaultComponentSerializer.set(GSON_SERIALIZER);
        ArrayList<CharacterAndFormat> formats = new ArrayList<CharacterAndFormat>(CharacterAndFormat.defaults());
        formats.remove(CharacterAndFormat.STRIKETHROUGH);
        formats.remove(CharacterAndFormat.UNDERLINED);
        formats.add(CharacterAndFormat.characterAndFormat((char)'g', (TextFormat)TextColor.color((int)221, (int)214, (int)5)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'h', (TextFormat)TextColor.color((int)227, (int)212, (int)209)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'i', (TextFormat)TextColor.color((int)206, (int)202, (int)202)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'j', (TextFormat)TextColor.color((int)68, (int)58, (int)59)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'m', (TextFormat)TextColor.color((int)151, (int)22, (int)7)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'n', (TextFormat)TextColor.color((int)180, (int)104, (int)77)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'p', (TextFormat)TextColor.color((int)222, (int)177, (int)45)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'q', (TextFormat)TextColor.color((int)17, (int)160, (int)54)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'s', (TextFormat)TextColor.color((int)44, (int)186, (int)168)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'t', (TextFormat)TextColor.color((int)33, (int)73, (int)123)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'u', (TextFormat)TextColor.color((int)154, (int)92, (int)198)));
        ComponentFlattener flattener = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).mapper(ScoreComponent.class, component -> "").build();
        BEDROCK_SERIALIZER = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacySection().toBuilder()).formats(formats).flattener(flattener).build();
        StringBuilder colorBuilder = new StringBuilder();
        for (CharacterAndFormat format : formats) {
            if (!(format.format() instanceof TextColor)) continue;
            colorBuilder.append(format.character());
        }
        BEDROCK_COLORS = colorBuilder.toString();
    }
}

