/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.item;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.components.Rarity;
import org.geysermc.geyser.item.type.BedrockRequiresTagItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.CustomSkull;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.item.CustomItemTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.ModifierOperation;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AdventureModePredicate;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemAttributeModifiers;

public final class ItemTranslator {
    private static final EnumMap<ItemAttributeModifiers.EquipmentSlotGroup, String> SLOT_NAMES;
    private static final ItemAttributeModifiers.EquipmentSlotGroup[] ARMOR_SLOT_NAMES;
    private static final DecimalFormat ATTRIBUTE_FORMAT;

    private ItemTranslator() {
    }

    public static ItemStack translateToJava(GeyserSession session, ItemData data) {
        if (data == null) {
            return new ItemStack(Items.AIR_ID);
        }
        ItemMapping bedrockItem = session.getItemMappings().getMapping(data);
        Item javaItem = bedrockItem.getJavaItem();
        GeyserItemStack itemStack = javaItem.translateToJava(data, bedrockItem, session.getItemMappings());
        NbtMap nbt = data.getTag();
        if (nbt != null && !nbt.isEmpty()) {
            DataComponents components = itemStack.getComponents() == null ? new DataComponents(new HashMap()) : itemStack.getComponents();
            javaItem.translateNbtToJava(session, nbt, components, bedrockItem);
            if (!components.getDataComponents().isEmpty()) {
                itemStack.setComponents(components);
            }
        }
        return itemStack.getItemStack();
    }

    public static @NonNull ItemData.Builder translateToBedrock(GeyserSession session, int javaId, int count, DataComponents components) {
        ItemMapping bedrockItem = session.getItemMappings().getMapping(javaId);
        if (bedrockItem == ItemMapping.AIR) {
            session.getGeyser().getLogger().debug("ItemMapping returned air: " + javaId);
            return ItemData.builder();
        }
        return ItemTranslator.translateToBedrock(session, (Item)((List)Registries.JAVA_ITEMS.get()).get(javaId), bedrockItem, count, components);
    }

    public static @NonNull ItemData translateToBedrock(GeyserSession session, ItemStack stack) {
        if (InventoryUtils.isEmpty(stack)) {
            return ItemData.AIR;
        }
        ItemMapping bedrockItem = session.getItemMappings().getMapping(stack);
        if (bedrockItem == ItemMapping.AIR) {
            session.getGeyser().getLogger().debug("ItemMapping returned air: " + stack);
            return ItemData.AIR;
        }
        return ItemTranslator.translateToBedrock(session, (Item)((List)Registries.JAVA_ITEMS.get()).get(stack.getId()), bedrockItem, stack.getAmount(), stack.getDataComponents()).build();
    }

    public static @NonNull ItemData.Builder translateToBedrock(GeyserSession session, Item javaItem, ItemMapping bedrockItem, int count, @Nullable DataComponents components) {
        ItemAttributeModifiers attributeModifiers;
        String customName;
        BedrockItemBuilder nbtBuilder = new BedrockItemBuilder();
        boolean hideTooltips = false;
        if (components != null) {
            javaItem.translateComponentsToBedrock(session, components, nbtBuilder);
            if (components.get(DataComponentType.HIDE_TOOLTIP) != null) {
                hideTooltips = true;
            }
        }
        if (javaItem instanceof BedrockRequiresTagItem) {
            BedrockRequiresTagItem requiresTagItem = (BedrockRequiresTagItem)((Object)javaItem);
            requiresTagItem.addRequiredNbt(session, components, nbtBuilder);
        }
        Rarity rarity = javaItem.rarity();
        boolean enchantmentGlint = javaItem.glint();
        if (components != null) {
            Boolean enchantmentGlintOverride;
            Integer rarityIndex = components.get(DataComponentType.RARITY);
            if (rarityIndex != null) {
                rarity = Rarity.fromId(rarityIndex);
            }
            if ((enchantmentGlintOverride = components.get(DataComponentType.ENCHANTMENT_GLINT_OVERRIDE)) != null) {
                enchantmentGlint = enchantmentGlintOverride;
            }
        }
        if ((customName = ItemTranslator.getCustomName(session, components, bedrockItem, rarity.getColor())) != null) {
            nbtBuilder.setCustomName(customName);
        }
        if (components != null && (attributeModifiers = components.get(DataComponentType.ATTRIBUTE_MODIFIERS)) != null && attributeModifiers.isShowInTooltip() && !hideTooltips) {
            ItemTranslator.addAttributeLore(attributeModifiers, nbtBuilder, session.locale());
        }
        if (session.isAdvancedTooltips() && !hideTooltips) {
            ItemTranslator.addAdvancedTooltips(components, nbtBuilder, javaItem, session.locale());
        }
        if (enchantmentGlint) {
            NbtMapBuilder nbtMapBuilder = nbtBuilder.getOrCreateNbt();
            nbtMapBuilder.putIfAbsent("ench", NbtList.EMPTY);
        }
        ItemData.Builder builder = javaItem.translateToBedrock(count, components, bedrockItem, session.getItemMappings());
        builder.tag(nbtBuilder.build());
        if (bedrockItem.isBlock()) {
            CustomBlockData customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(bedrockItem.getJavaItem().javaIdentifier(), null);
            if (customBlockData != null) {
                ItemTranslator.translateCustomBlock(customBlockData, session, builder);
            } else {
                builder.blockDefinition(bedrockItem.getBedrockBlockDefinition());
            }
        }
        if (bedrockItem.getJavaItem().equals(Items.PLAYER_HEAD)) {
            ItemTranslator.translatePlayerHead(session, components, builder);
        }
        ItemTranslator.translateCustomItem(components, builder, bedrockItem);
        if (components != null) {
            AdventureModePredicate canDestroy = components.get(DataComponentType.CAN_BREAK);
            AdventureModePredicate canPlaceOn = components.get(DataComponentType.CAN_PLACE_ON);
            String[] canBreak = ItemTranslator.getCanModify(session, canDestroy);
            String[] canPlace = ItemTranslator.getCanModify(session, canPlaceOn);
            if (canBreak != null) {
                builder.canBreak(canBreak);
            }
            if (canPlace != null) {
                builder.canPlace(canPlace);
            }
        }
        return builder;
    }

    private static void addAttributeLore(ItemAttributeModifiers modifiers, BedrockItemBuilder builder, String language) {
        HashMap<ItemAttributeModifiers.EquipmentSlotGroup, List> slotsToModifiers = new HashMap<ItemAttributeModifiers.EquipmentSlotGroup, List>();
        for (ItemAttributeModifiers.Entry entry : modifiers.getModifiers()) {
            String loreEntry = ItemTranslator.attributeToLore(entry.getAttribute(), entry.getModifier(), language);
            if (loreEntry == null) continue;
            ItemAttributeModifiers.EquipmentSlotGroup slotGroup = entry.getSlot();
            if (slotGroup == ItemAttributeModifiers.EquipmentSlotGroup.ARMOR) {
                for (ItemAttributeModifiers.EquipmentSlotGroup slot : ARMOR_SLOT_NAMES) {
                    slotsToModifiers.computeIfAbsent(slot, s -> new ArrayList()).add(loreEntry);
                }
                continue;
            }
            if (slotGroup == ItemAttributeModifiers.EquipmentSlotGroup.ANY) {
                for (ItemAttributeModifiers.EquipmentSlotGroup slot : SLOT_NAMES.keySet()) {
                    slotsToModifiers.computeIfAbsent(slot, s -> new ArrayList()).add(loreEntry);
                }
                continue;
            }
            slotsToModifiers.computeIfAbsent(slotGroup, s -> new ArrayList()).add(loreEntry);
        }
        for (ItemAttributeModifiers.EquipmentSlotGroup slot : SLOT_NAMES.keySet()) {
            List modifierStrings = (List)slotsToModifiers.get((Object)slot);
            if (modifierStrings == null || modifierStrings.isEmpty()) continue;
            BuildableComponent slotComponent = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color((TextColor)NamedTextColor.GRAY)).append(new Component[]{Component.newline(), Component.translatable((String)("item.modifiers." + SLOT_NAMES.get((Object)slot)))})).build();
            builder.getOrCreateLore().add(MessageTranslator.convertMessage((Component)slotComponent, language));
            for (String modifier : modifierStrings) {
                builder.getOrCreateLore().add(modifier);
            }
        }
    }

    private static @Nullable String attributeToLore(int attribute, ItemAttributeModifiers.AttributeModifier modifier, String language) {
        Object operationTotal;
        double amount = modifier.getAmount();
        if (amount == 0.0) {
            return null;
        }
        String name = AttributeType.Builtin.from(attribute).getIdentifier().asMinimalString();
        ModifierOperation operation = modifier.getOperation();
        switch (operation) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ADD: {
                if (name.equals("generic.knockback_resistance")) {
                    amount *= 10.0;
                }
                Object object = ATTRIBUTE_FORMAT.format(amount);
                break;
            }
            case ADD_MULTIPLIED_BASE: 
            case ADD_MULTIPLIED_TOTAL: {
                Object object = operationTotal = ATTRIBUTE_FORMAT.format(amount * 100.0) + "%";
            }
        }
        if (amount > 0.0) {
            operationTotal = "+" + (String)operationTotal;
        }
        BuildableComponent attributeComponent = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color((TextColor)(amount > 0.0 ? NamedTextColor.BLUE : NamedTextColor.RED))).append(new Component[]{Component.text((String)((String)operationTotal + " ")), Component.translatable((String)("attribute.name." + name))})).build();
        return MessageTranslator.convertMessage((Component)attributeComponent, language);
    }

    private static void addAdvancedTooltips(@Nullable DataComponents components, BedrockItemBuilder builder, Item item, String language) {
        int durability;
        Integer durabilityComponent;
        int maxDurability = item.maxDamage();
        if (maxDurability != 0 && components != null && (durabilityComponent = components.get(DataComponentType.DAMAGE)) != null && (durability = maxDurability - durabilityComponent) != maxDurability) {
            BuildableComponent component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color((TextColor)NamedTextColor.WHITE)).append((Component)Component.translatable((String)"item.durability", (ComponentLike[])new ComponentLike[]{Component.text((int)durability), Component.text((int)maxDurability)}))).build();
            builder.getOrCreateLore().add(MessageTranslator.convertMessage((Component)component, language));
        }
        builder.getOrCreateLore().add("\u00a7r\u00a78" + item.javaIdentifier());
        if (components != null) {
            BuildableComponent component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.translatable((String)"item.components", (ComponentLike[])new ComponentLike[]{Component.text((int)components.getDataComponents().size())}))).build();
            builder.getOrCreateLore().add(MessageTranslator.convertMessage((Component)component, language));
        }
    }

    private static String @Nullable [] getCanModify(GeyserSession session, @Nullable AdventureModePredicate canModifyJava) {
        if (canModifyJava == null) {
            return null;
        }
        List<AdventureModePredicate.BlockPredicate> predicates = canModifyJava.getPredicates();
        if (!predicates.isEmpty()) {
            ArrayList<String> canModifyBedrock = new ArrayList<String>();
            for (int i = 0; i < predicates.size(); ++i) {
                int[] holders;
                HolderSet holderSet = predicates.get(i).getBlocks();
                if (holderSet == null || (holders = holderSet.getHolders()) == null) continue;
                for (int blockId : holders) {
                    Block block = BlockRegistries.JAVA_BLOCKS.get(blockId);
                    if (block == null) continue;
                    String identifier = (String)session.getBlockMappings().getJavaToBedrockIdentifiers().get(block.javaId());
                    if (identifier == null) {
                        canModifyBedrock.add(block.javaIdentifier().value());
                        continue;
                    }
                    canModifyBedrock.add(identifier);
                }
            }
            return canModifyBedrock.toArray(new String[0]);
        }
        return null;
    }

    public static @NonNull ItemDefinition getBedrockItemDefinition(GeyserSession session, @NonNull GeyserItemStack itemStack) {
        ItemDefinition definition;
        CustomSkull customSkull;
        if (itemStack.isEmpty()) {
            return ItemDefinition.AIR;
        }
        ItemMapping mapping = itemStack.asItem().toBedrockDefinition(itemStack.getComponents(), session.getItemMappings());
        ItemDefinition itemDefinition = mapping.getBedrockDefinition();
        CustomBlockData customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(mapping.getJavaItem().javaIdentifier(), null);
        if (customBlockData != null) {
            itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customBlockData);
        }
        if (mapping.getJavaItem().equals(Items.PLAYER_HEAD) && (customSkull = ItemTranslator.getCustomSkull(itemStack.getComponents())) != null) {
            itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customSkull.getCustomBlockData());
        }
        if ((definition = CustomItemTranslator.getCustomItem(itemStack.getComponents(), mapping)) == null) {
            return itemDefinition;
        }
        return definition;
    }

    public static String getCustomName(GeyserSession session, DataComponents components, ItemMapping mapping, char translationColor) {
        if (components != null) {
            Component customName = components.get(DataComponentType.CUSTOM_NAME);
            if (customName != null) {
                return MessageTranslator.convertMessage(customName, session.locale());
            }
            customName = components.get(DataComponentType.ITEM_NAME);
            if (customName != null) {
                return "\u00a7r\u00a7" + translationColor + MessageTranslator.convertMessage(customName, session.locale());
            }
        }
        if (mapping.hasTranslation()) {
            String translationKey = mapping.getTranslationString();
            return "\u00a7r\u00a7" + translationColor + MinecraftLocale.getLocaleString(translationKey, session.locale());
        }
        return null;
    }

    public static void translateCustomItem(DataComponents components, ItemData.Builder builder, ItemMapping mapping) {
        ItemDefinition definition = CustomItemTranslator.getCustomItem(components, mapping);
        if (definition != null) {
            builder.definition(definition);
            builder.blockDefinition(null);
        }
    }

    private static void translateCustomBlock(CustomBlockData customBlockData, GeyserSession session, ItemData.Builder builder) {
        ItemDefinition itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customBlockData);
        BlockDefinition blockDefinition = (BlockDefinition)session.getBlockMappings().getCustomBlockStateDefinitions().get(customBlockData.defaultBlockState());
        builder.definition(itemDefinition);
        builder.blockDefinition(blockDefinition);
    }

    private static @Nullable CustomSkull getCustomSkull(DataComponents components) {
        if (components == null) {
            return null;
        }
        GameProfile profile = components.get(DataComponentType.PROFILE);
        if (profile != null) {
            Map<GameProfile.TextureType, GameProfile.Texture> textures = profile.getTextures(false);
            if (textures == null || textures.isEmpty()) {
                return null;
            }
            GameProfile.Texture skinTexture = textures.get((Object)GameProfile.TextureType.SKIN);
            if (skinTexture == null) {
                return null;
            }
            String skinHash = skinTexture.getURL().substring(skinTexture.getURL().lastIndexOf(47) + 1);
            return (CustomSkull)BlockRegistries.CUSTOM_SKULLS.get(skinHash);
        }
        return null;
    }

    private static void translatePlayerHead(GeyserSession session, DataComponents components, ItemData.Builder builder) {
        CustomSkull customSkull = ItemTranslator.getCustomSkull(components);
        if (customSkull != null) {
            CustomBlockData customBlockData = customSkull.getCustomBlockData();
            ItemDefinition itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customBlockData);
            BlockDefinition blockDefinition = (BlockDefinition)session.getBlockMappings().getCustomBlockStateDefinitions().get(customBlockData.defaultBlockState());
            builder.definition(itemDefinition);
            builder.blockDefinition(blockDefinition);
        }
    }

    static {
        ARMOR_SLOT_NAMES = new ItemAttributeModifiers.EquipmentSlotGroup[]{ItemAttributeModifiers.EquipmentSlotGroup.HEAD, ItemAttributeModifiers.EquipmentSlotGroup.CHEST, ItemAttributeModifiers.EquipmentSlotGroup.LEGS, ItemAttributeModifiers.EquipmentSlotGroup.FEET};
        ATTRIBUTE_FORMAT = new DecimalFormat("0.#####");
        SLOT_NAMES = new EnumMap(ItemAttributeModifiers.EquipmentSlotGroup.class);
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.MAIN_HAND, "mainhand");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.OFF_HAND, "offhand");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.FEET, "feet");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.LEGS, "legs");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.CHEST, "chest");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.HEAD, "head");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.BODY, "body");
    }
}

