/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Generic3X3Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;

public class Generic3X3InventoryTranslator
extends AbstractBlockInventoryTranslator {
    public Generic3X3InventoryTranslator() {
        super(9, Blocks.DISPENSER, ContainerType.DISPENSER, (InventoryUpdater)ContainerInventoryUpdater.INSTANCE, Blocks.DROPPER);
    }

    @Override
    public Inventory createInventory(String name, int windowId, org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType containerType, PlayerInventory playerInventory) {
        return new Generic3X3Container(name, windowId, this.size, containerType, playerInventory);
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
        containerOpenPacket.setId((byte)inventory.getBedrockId());
        containerOpenPacket.setType(((Generic3X3Container)inventory).isDropper() ? ContainerType.DROPPER : ContainerType.DISPENSER);
        containerOpenPacket.setBlockPosition(inventory.getHolderPosition());
        containerOpenPacket.setUniqueEntityId(inventory.getHolderId());
        session.sendUpstreamPacket(containerOpenPacket);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int javaSlot) {
        if (javaSlot < this.size) {
            return new BedrockContainerSlot(ContainerSlotType.LEVEL_ENTITY, javaSlot);
        }
        return super.javaSlotToBedrockContainer(javaSlot);
    }
}

