/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.Map;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityMotionPacket;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.PistonBlockEntity;

public class PistonCache {
    private final GeyserSession session;
    private final Map<Vector3i, PistonBlockEntity> pistons = new Object2ObjectOpenHashMap<Vector3i, PistonBlockEntity>();
    private final Map<Vector3i, PistonBlockEntity> movingBlocksMap = new Object2ObjectOpenHashMap<Vector3i, PistonBlockEntity>();
    private Vector3d playerDisplacement = Vector3d.ZERO;
    private Vector3f playerMotion = Vector3f.ZERO;
    private boolean playerCollided = false;
    private boolean playerSlimeCollision = false;
    private boolean playerAttachedToHoney = false;

    public PistonCache(GeyserSession session) {
        this.session = session;
    }

    public void tick() {
        this.resetPlayerMovement();
        if (!this.pistons.isEmpty()) {
            this.pistons.values().forEach(PistonBlockEntity::updateMovement);
            this.sendPlayerMovement();
            this.sendPlayerMotion();
            this.pistons.values().forEach(PistonBlockEntity::updateBlocks);
            this.pistons.entrySet().removeIf(entry -> ((PistonBlockEntity)entry.getValue()).canBeRemoved());
            if (this.pistons.isEmpty() && !this.movingBlocksMap.isEmpty()) {
                this.session.getGeyser().getLogger().error("The moving block map has de-synced!");
                for (Map.Entry<Vector3i, PistonBlockEntity> entry2 : this.movingBlocksMap.entrySet()) {
                    this.session.getGeyser().getLogger().error("Moving Block at " + entry2.getKey() + " was previously owned by the piston at " + entry2.getValue().getPosition());
                }
            }
        }
    }

    private void resetPlayerMovement() {
        this.playerDisplacement = Vector3d.ZERO;
        this.playerMotion = Vector3f.ZERO;
        this.playerCollided = false;
        this.playerSlimeCollision = false;
        this.playerAttachedToHoney = false;
    }

    private void sendPlayerMovement() {
        if (!this.playerDisplacement.equals(Vector3d.ZERO) && this.playerMotion.equals(Vector3f.ZERO)) {
            SessionPlayerEntity playerEntity = this.session.getPlayerEntity();
            boolean isOnGround = this.playerDisplacement.getY() > 0.0 || playerEntity.isOnGround();
            Vector3d position = this.session.getCollisionManager().getPlayerBoundingBox().getBottomCenter();
            playerEntity.moveAbsolute(position.toFloat(), playerEntity.getYaw(), playerEntity.getPitch(), playerEntity.getHeadYaw(), isOnGround, true);
        }
    }

    private void sendPlayerMotion() {
        if (!this.playerMotion.equals(Vector3f.ZERO)) {
            SessionPlayerEntity playerEntity = this.session.getPlayerEntity();
            playerEntity.setMotion(this.playerMotion);
            SetEntityMotionPacket setEntityMotionPacket = new SetEntityMotionPacket();
            setEntityMotionPacket.setRuntimeEntityId(playerEntity.getGeyserId());
            setEntityMotionPacket.setMotion(this.playerMotion);
            this.session.sendUpstreamPacket(setEntityMotionPacket);
        }
    }

    public void displacePlayer(Vector3d displacement) {
        Vector3d totalDisplacement = this.playerDisplacement.add(displacement);
        totalDisplacement = totalDisplacement.max(-0.51, -0.51, -0.51).min(0.51, 0.51, 0.51);
        Vector3d delta = totalDisplacement.sub(this.playerDisplacement);
        delta = this.session.getCollisionManager().correctPlayerMovement(delta, true, false);
        this.session.getCollisionManager().getPlayerBoundingBox().translate(delta.getX(), delta.getY(), delta.getZ());
        this.playerDisplacement = totalDisplacement;
    }

    public double computeCollisionOffset(Vector3i blockPos, BoundingBox boundingBox, Axis axis, double offset) {
        PistonBlockEntity piston = this.movingBlocksMap.get(blockPos);
        if (piston != null) {
            return piston.computeCollisionOffset(blockPos, boundingBox, axis, offset);
        }
        return offset;
    }

    public boolean checkCollision(Vector3i blockPos, BoundingBox boundingBox) {
        PistonBlockEntity piston = this.movingBlocksMap.get(blockPos);
        if (piston != null) {
            return piston.checkCollision(blockPos, boundingBox);
        }
        return false;
    }

    public void clear() {
        this.pistons.clear();
        this.movingBlocksMap.clear();
    }

    public Map<Vector3i, PistonBlockEntity> getPistons() {
        return this.pistons;
    }

    public Map<Vector3i, PistonBlockEntity> getMovingBlocksMap() {
        return this.movingBlocksMap;
    }

    public Vector3d getPlayerDisplacement() {
        return this.playerDisplacement;
    }

    public Vector3f getPlayerMotion() {
        return this.playerMotion;
    }

    public boolean isPlayerCollided() {
        return this.playerCollided;
    }

    public boolean isPlayerSlimeCollision() {
        return this.playerSlimeCollision;
    }

    public boolean isPlayerAttachedToHoney() {
        return this.playerAttachedToHoney;
    }

    private GeyserSession getSession() {
        return this.session;
    }

    public void setPlayerMotion(Vector3f playerMotion) {
        this.playerMotion = playerMotion;
    }

    public void setPlayerCollided(boolean playerCollided) {
        this.playerCollided = playerCollided;
    }

    public void setPlayerSlimeCollision(boolean playerSlimeCollision) {
        this.playerSlimeCollision = playerSlimeCollision;
    }

    public void setPlayerAttachedToHoney(boolean playerAttachedToHoney) {
        this.playerAttachedToHoney = playerAttachedToHoney;
    }
}

