/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.GeyserMappingItem;

public class Conversion685_671 {
    private static final List<String> NEW_CORAL_BLOCKS = List.of("minecraft:tube_coral_block", "minecraft:brain_coral_block", "minecraft:bubble_coral_block", "minecraft:fire_coral_block", "minecraft:horn_coral_block", "minecraft:dead_tube_coral_block", "minecraft:dead_brain_coral_block", "minecraft:dead_bubble_coral_block", "minecraft:dead_fire_coral_block", "minecraft:dead_horn_coral_block");
    private static final List<String> NEW_DOUBLE_PLANTS = List.of("minecraft:sunflower", "minecraft:lilac", "minecraft:tall_grass", "minecraft:large_fern", "minecraft:rose_bush", "minecraft:peony");
    private static final List<String> NEW_STONE_BLOCK_SLABS = List.of("minecraft:smooth_stone_slab", "minecraft:sandstone_slab", "minecraft:petrified_oak_slab", "minecraft:cobblestone_slab", "minecraft:brick_slab", "minecraft:stone_brick_slab", "minecraft:quartz_slab", "minecraft:nether_brick_slab");
    private static final List<String> NEW_TALLGRASSES = List.of("minecraft:fern", "minecraft:short_grass");
    private static final List<String> OMINOUS_BLOCKS = List.of("minecraft:trial_spawner", "minecraft:vault");
    private static final List<String> NEW_BLOCKS = Stream.of(NEW_CORAL_BLOCKS, NEW_DOUBLE_PLANTS, NEW_STONE_BLOCK_SLABS, NEW_TALLGRASSES).flatMap(Collection::stream).toList();
    private static final List<String> MODIFIED_BLOCKS = Stream.of(NEW_BLOCKS, OMINOUS_BLOCKS).flatMap(Collection::stream).toList();
    private static final List<Item> NEW_MUSIC_DISCS = List.of(Items.MUSIC_DISC_CREATOR, Items.MUSIC_DISC_CREATOR_MUSIC_BOX, Items.MUSIC_DISC_PRECIPICE);

    static GeyserMappingItem remapItem(Item item, GeyserMappingItem mapping) {
        String identifer = mapping.getBedrockIdentifier();
        if (NEW_MUSIC_DISCS.contains(item)) {
            return mapping.withBedrockIdentifier("minecraft:music_disc_otherside");
        }
        if (item == Items.OMINOUS_TRIAL_KEY) {
            return mapping.withBedrockIdentifier("minecraft:trial_key");
        }
        if (item == Items.OMINOUS_BOTTLE) {
            return mapping.withBedrockIdentifier("minecraft:glass_bottle");
        }
        if (!NEW_BLOCKS.contains(identifer)) {
            return mapping;
        }
        if (NEW_CORAL_BLOCKS.contains(identifer)) {
            switch (identifer) {
                case "minecraft:tube_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(0);
                }
                case "minecraft:brain_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(1);
                }
                case "minecraft:bubble_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(2);
                }
                case "minecraft:fire_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(3);
                }
                case "minecraft:horn_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(4);
                }
                case "minecraft:dead_tube_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(8);
                }
                case "minecraft:dead_brain_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(9);
                }
                case "minecraft:dead_bubble_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(10);
                }
                case "minecraft:dead_fire_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(11);
                }
                case "minecraft:dead_horn_coral_block": {
                    return mapping.withBedrockIdentifier("minecraft:coral_block").withBedrockData(12);
                }
            }
        }
        if (NEW_DOUBLE_PLANTS.contains(identifer)) {
            switch (identifer) {
                case "minecraft:sunflower": {
                    return mapping.withBedrockIdentifier("minecraft:double_plant").withBedrockData(0);
                }
                case "minecraft:lilac": {
                    return mapping.withBedrockIdentifier("minecraft:double_plant").withBedrockData(1);
                }
                case "minecraft:tall_grass": {
                    return mapping.withBedrockIdentifier("minecraft:double_plant").withBedrockData(2);
                }
                case "minecraft:large_fern": {
                    return mapping.withBedrockIdentifier("minecraft:double_plant").withBedrockData(3);
                }
                case "minecraft:rose_bush": {
                    return mapping.withBedrockIdentifier("minecraft:double_plant").withBedrockData(4);
                }
                case "minecraft:peony": {
                    return mapping.withBedrockIdentifier("minecraft:double_plant").withBedrockData(5);
                }
            }
        }
        if (NEW_STONE_BLOCK_SLABS.contains(identifer)) {
            switch (identifer) {
                case "minecraft:smooth_stone_slab": {
                    return mapping.withBedrockIdentifier("minecraft:stone_block_slab").withBedrockData(0);
                }
                case "minecraft:sandstone_slab": {
                    return mapping.withBedrockIdentifier("minecraft:stone_block_slab").withBedrockData(1);
                }
                case "minecraft:petrified_oak_slab": {
                    return mapping.withBedrockIdentifier("minecraft:stone_block_slab").withBedrockData(2);
                }
                case "minecraft:cobblestone_slab": {
                    return mapping.withBedrockIdentifier("minecraft:stone_block_slab").withBedrockData(3);
                }
                case "minecraft:brick_slab": {
                    return mapping.withBedrockIdentifier("minecraft:stone_block_slab").withBedrockData(4);
                }
                case "minecraft:stone_brick_slab": {
                    return mapping.withBedrockIdentifier("minecraft:stone_block_slab").withBedrockData(5);
                }
                case "minecraft:quartz_slab": {
                    return mapping.withBedrockIdentifier("minecraft:stone_block_slab").withBedrockData(6);
                }
                case "minecraft:nether_brick_slab": {
                    return mapping.withBedrockIdentifier("minecraft:stone_block_slab").withBedrockData(7);
                }
            }
        }
        if (NEW_TALLGRASSES.contains(identifer)) {
            switch (identifer) {
                case "minecraft:short_grass": {
                    return mapping.withBedrockIdentifier("minecraft:tallgrass").withBedrockData(1);
                }
                case "minecraft:fern": {
                    return mapping.withBedrockIdentifier("minecraft:tallgrass").withBedrockData(2);
                }
            }
        }
        return mapping;
    }

    static NbtMap remapBlock(NbtMap tag) {
        String name = tag.getString("name");
        if (!MODIFIED_BLOCKS.contains(name)) {
            return tag;
        }
        if (OMINOUS_BLOCKS.contains(name)) {
            NbtMapBuilder builder = tag.getCompound("states").toBuilder();
            builder.remove("ominous");
            return tag.toBuilder().putCompound("states", builder.build()).build();
        }
        if (NEW_CORAL_BLOCKS.contains(name)) {
            String replacement = "minecraft:coral_block";
            boolean deadBit = name.startsWith("minecraft:dead_");
            NbtMap states = tag.getCompound("states").toBuilder().putString("coral_color", switch (name) {
                case "minecraft:tube_coral_block", "minecraft:dead_tube_coral_block" -> "blue";
                case "minecraft:brain_coral_block", "minecraft:dead_brain_coral_block" -> "pink";
                case "minecraft:bubble_coral_block", "minecraft:dead_bubble_coral_block" -> "purple";
                case "minecraft:fire_coral_block", "minecraft:dead_fire_coral_block" -> "yellow";
                case "minecraft:horn_coral_block", "minecraft:dead_horn_coral_block" -> "red";
                default -> throw new IllegalStateException("Unexpected value: " + name);
            }).putBoolean("dead_bit", deadBit).build();
            return tag.toBuilder().putString("name", replacement).putCompound("states", states).build();
        }
        if (NEW_DOUBLE_PLANTS.contains(name)) {
            String replacement = "minecraft:double_plant";
            NbtMap states = tag.getCompound("states").toBuilder().putString("double_plant_type", switch (name) {
                case "minecraft:sunflower" -> "sunflower";
                case "minecraft:lilac" -> "syringa";
                case "minecraft:tall_grass" -> "grass";
                case "minecraft:large_fern" -> "fern";
                case "minecraft:rose_bush" -> "rose";
                case "minecraft:peony" -> "paeonia";
                default -> throw new IllegalStateException("Unexpected value: " + name);
            }).build();
            return tag.toBuilder().putString("name", replacement).putCompound("states", states).build();
        }
        if (NEW_STONE_BLOCK_SLABS.contains(name)) {
            String replacement = "minecraft:stone_block_slab";
            Object states = tag.getCompound("states").toBuilder().putString("stone_slab_type", switch (name) {
                case "minecraft:smooth_stone_slab" -> "smooth_stone";
                case "minecraft:sandstone_slab" -> "sandstone";
                case "minecraft:petrified_oak_slab" -> "wood";
                case "minecraft:cobblestone_slab" -> "cobblestone";
                case "minecraft:brick_slab" -> "brick";
                case "minecraft:stone_brick_slab" -> "stone_brick";
                case "minecraft:quartz_slab" -> "quartz";
                case "minecraft:nether_brick_slab" -> "nether_brick";
                default -> throw new IllegalStateException("Unexpected value: " + name);
            }).build();
            return tag.toBuilder().putString("name", replacement).putCompound("states", (NbtMap)states).build();
        }
        if (NEW_TALLGRASSES.contains(name)) {
            String replacement = "minecraft:tallgrass";
            Object states = tag.getCompound("states").toBuilder().putString("tall_grass_type", switch (name) {
                case "minecraft:short_grass" -> "tall";
                case "minecraft:fern" -> "fern";
                default -> throw new IllegalStateException("Unexpected value: " + name);
            }).build();
            return tag.toBuilder().putString("name", replacement).putCompound("states", (NbtMap)states).build();
        }
        return tag;
    }
}

