/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity.command;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.text.GeyserLocale;

public class VelocityCommandSource
implements GeyserCommandSource {
    private final CommandSource handle;

    public VelocityCommandSource(CommandSource handle) {
        this.handle = handle;
        GeyserLocale.loadGeyserLocale(this.locale());
    }

    @Override
    public String name() {
        if (this.handle instanceof Player) {
            return ((Player)this.handle).getUsername();
        }
        if (this.handle instanceof ConsoleCommandSource) {
            return "CONSOLE";
        }
        return "";
    }

    @Override
    public void sendMessage(@NonNull String message) {
        this.handle.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message));
    }

    @Override
    public void sendMessage(Component message) {
        this.handle.sendMessage(message);
    }

    @Override
    public boolean isConsole() {
        return this.handle instanceof ConsoleCommandSource;
    }

    @Override
    public String locale() {
        if (this.handle instanceof Player) {
            Locale locale = ((Player)this.handle).getPlayerSettings().getLocale();
            return GeyserLocale.formatLocale(locale.getLanguage() + "_" + locale.getCountry());
        }
        return GeyserLocale.getDefaultLocale();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.handle.hasPermission(permission);
    }
}

