/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity.command;

import com.velocitypowered.api.command.SimpleCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandExecutor;
import org.geysermc.geyser.platform.velocity.command.VelocityCommandSource;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class GeyserVelocityCommandExecutor
extends GeyserCommandExecutor
implements SimpleCommand {
    public GeyserVelocityCommandExecutor(GeyserImpl geyser, Map<String, Command> commands) {
        super(geyser, commands);
    }

    public void execute(SimpleCommand.Invocation invocation) {
        VelocityCommandSource sender = new VelocityCommandSource(invocation.source());
        GeyserSession session = this.getGeyserSession(sender);
        if (((String[])invocation.arguments()).length > 0) {
            GeyserCommand command = this.getCommand(((String[])invocation.arguments())[0]);
            if (command != null) {
                if (!invocation.source().hasPermission(this.getCommand(((String[])invocation.arguments())[0]).permission())) {
                    sender.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.permission_fail", sender.locale()));
                    return;
                }
                if (command.isBedrockOnly() && session == null) {
                    sender.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.bedrock_only", sender.locale()));
                    return;
                }
                command.execute(session, sender, ((String[])invocation.arguments()).length > 1 ? Arrays.copyOfRange((String[])invocation.arguments(), 1, ((String[])invocation.arguments()).length) : new String[]{});
            } else {
                String message = GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.not_found", sender.locale());
                sender.sendMessage("\u00a7c" + message);
            }
        } else {
            this.getCommand("help").execute(session, sender, new String[0]);
        }
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        if (((String[])invocation.arguments()).length == 0 || ((String[])invocation.arguments()).length == 1) {
            return this.tabComplete(new VelocityCommandSource(invocation.source()));
        }
        return Collections.emptyList();
    }
}

