/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ListenerBoundEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.network.ListenerType;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommandManager;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.velocity.GeyserVelocityConfiguration;
import org.geysermc.geyser.platform.velocity.GeyserVelocityDumpInfo;
import org.geysermc.geyser.platform.velocity.GeyserVelocityInjector;
import org.geysermc.geyser.platform.velocity.GeyserVelocityLogger;
import org.geysermc.geyser.platform.velocity.GeyserVelocityPingPassthrough;
import org.geysermc.geyser.platform.velocity.GeyserVelocityUpdateListener;
import org.geysermc.geyser.platform.velocity.command.GeyserVelocityCommandExecutor;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.slf4j.Logger;

@Plugin(id="geyser", name="Geyser-Velocity", version="2.4.0-SNAPSHOT (git-DEV-fbea2cb)", url="https://geysermc.org", authors={"GeyserMC"})
public class GeyserVelocityPlugin
implements GeyserBootstrap {
    private final ProxyServer proxyServer;
    private final CommandManager commandManager;
    private final GeyserVelocityLogger geyserLogger;
    private GeyserCommandManager geyserCommandManager;
    private GeyserVelocityConfiguration geyserConfig;
    private GeyserVelocityInjector geyserInjector;
    private IGeyserPingPassthrough geyserPingPassthrough;
    private GeyserImpl geyser;
    private final Path configFolder = Paths.get("plugins/Geyser-Velocity/", new String[0]);

    @Inject
    public GeyserVelocityPlugin(ProxyServer server, Logger logger, CommandManager manager) {
        this.geyserLogger = new GeyserVelocityLogger(logger);
        this.proxyServer = server;
        this.commandManager = manager;
    }

    @Override
    public void onGeyserInitialize() {
        GeyserLocale.init(this);
        if (!ProtocolVersion.isSupported((int)GameProtocol.getJavaProtocolVersion())) {
            this.geyserLogger.error("      / \\");
            this.geyserLogger.error("     /   \\");
            this.geyserLogger.error("    /  |  \\");
            this.geyserLogger.error("   /   |   \\    " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_proxy", this.proxyServer.getVersion().getName()));
            this.geyserLogger.error("  /         \\   " + GeyserLocale.getLocaleStringLog("geyser.may_not_work_as_intended_all_caps"));
            this.geyserLogger.error(" /     o     \\");
            this.geyserLogger.error("/_____________\\");
        }
        if (!this.loadConfig()) {
            return;
        }
        this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        this.geyser = GeyserImpl.load(PlatformType.VELOCITY, this);
        this.geyserInjector = new GeyserVelocityInjector(this.proxyServer);
    }

    @Override
    public void onGeyserEnable() {
        if (GeyserImpl.getInstance().isReloading()) {
            if (!this.loadConfig()) {
                return;
            }
            this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
            GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        } else {
            this.geyserCommandManager = new GeyserCommandManager(this.geyser);
            this.geyserCommandManager.init();
        }
        GeyserImpl.start();
        this.geyserPingPassthrough = this.geyserConfig.isLegacyPingPassthrough() ? GeyserLegacyPingPassthrough.init(this.geyser) : new GeyserVelocityPingPassthrough(this.proxyServer);
        if (GeyserImpl.getInstance().isReloading()) {
            return;
        }
        this.commandManager.register("geyser", (com.velocitypowered.api.command.Command)new GeyserVelocityCommandExecutor(this.geyser, this.geyserCommandManager.getCommands()), new String[0]);
        for (Map.Entry<Extension, Map<String, Command>> entry : this.geyserCommandManager.extensionCommands().entrySet()) {
            Map<String, Command> commands = entry.getValue();
            if (commands.isEmpty()) continue;
            this.commandManager.register(entry.getKey().description().id(), (com.velocitypowered.api.command.Command)new GeyserVelocityCommandExecutor(this.geyser, commands), new String[0]);
        }
        this.proxyServer.getEventManager().register((Object)this, (Object)new GeyserVelocityUpdateListener());
    }

    @Override
    public void onGeyserDisable() {
        if (this.geyser != null) {
            this.geyser.disable();
        }
    }

    @Override
    public void onGeyserShutdown() {
        if (this.geyser != null) {
            this.geyser.shutdown();
        }
        if (this.geyserInjector != null) {
            this.geyserInjector.shutdown();
        }
    }

    @Override
    public GeyserVelocityConfiguration getGeyserConfig() {
        return this.geyserConfig;
    }

    @Override
    public GeyserVelocityLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public GeyserCommandManager getGeyserCommandManager() {
        return this.geyserCommandManager;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserPingPassthrough;
    }

    @Subscribe
    public void onInit(ProxyInitializeEvent event) {
        this.onGeyserInitialize();
    }

    @Subscribe
    public void onShutdown(ProxyShutdownEvent event) {
        this.onGeyserShutdown();
    }

    @Subscribe
    public void onProxyBound(ListenerBoundEvent event) {
        if (event.getListenerType() == ListenerType.MINECRAFT) {
            this.onGeyserEnable();
            if (this.geyserInjector != null) {
                this.geyserInjector.initializeLocalChannel(this);
            }
        }
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserVelocityDumpInfo(this.proxyServer);
    }

    @Override
    public @Nullable SocketAddress getSocketAddress() {
        return this.geyserInjector.getServerSocketAddress();
    }

    @Override
    public @NonNull String getServerBindAddress() {
        return this.proxyServer.getBoundAddress().getHostString();
    }

    @Override
    public int getServerPort() {
        return this.proxyServer.getBoundAddress().getPort();
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        Optional floodgate = this.proxyServer.getPluginManager().getPlugin("floodgate");
        if (floodgate.isPresent()) {
            this.geyserConfig.loadFloodgate(this, this.proxyServer, this.configFolder.toFile());
            return true;
        }
        return false;
    }

    private boolean loadConfig() {
        try {
            if (!this.configFolder.toFile().exists()) {
                this.configFolder.toFile().mkdirs();
            }
            File configFile = FileUtils.fileOrCopiedFromResource(this.configFolder.resolve("config.yml").toFile(), "config.yml", x -> x.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.geyserConfig = FileUtils.loadConfig(configFile, GeyserVelocityConfiguration.class);
        }
        catch (IOException ex) {
            this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.config.failed"), ex);
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public Path getConfigFolder() {
        return this.configFolder;
    }
}

