/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.geyser.level.GameRule;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemCodecHelper;
import org.geysermc.mcprotocollib.protocol.data.game.setting.Difficulty;

public abstract class WorldManager {
    protected static final Function<Int2ObjectMap<byte[]>, DataComponents> RAW_TRANSFORMER = map -> {
        try {
            HashMap components = new HashMap();
            Int2ObjectMaps.fastForEach(map, entry -> {
                DataComponentType<?> type = DataComponentType.from(entry.getIntKey());
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])((byte[])entry.getValue()));
                DataComponent<?, DataComponentType<?>> value = type.readDataComponent(ItemCodecHelper.INSTANCE, buf);
                components.put(type, value);
            });
            return new DataComponents(components);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    };

    public final @NonNull BlockState blockAt(GeyserSession session, Vector3i vector) {
        return this.blockAt(session, vector.getX(), vector.getY(), vector.getZ());
    }

    public @NonNull BlockState blockAt(GeyserSession session, int x, int y, int z) {
        return BlockState.of(this.getBlockAt(session, x, y, z));
    }

    public final int getBlockAt(GeyserSession session, Vector3i vector) {
        return this.getBlockAt(session, vector.getX(), vector.getY(), vector.getZ());
    }

    public abstract int getBlockAt(GeyserSession var1, int var2, int var3, int var4);

    public final CompletableFuture<Integer> getBlockAtAsync(GeyserSession session, Vector3i vector) {
        return this.getBlockAtAsync(session, vector.getX(), vector.getY(), vector.getZ());
    }

    public CompletableFuture<Integer> getBlockAtAsync(GeyserSession session, int x, int y, int z) {
        return CompletableFuture.completedFuture(this.getBlockAt(session, x, y, z));
    }

    public int[] getBlocksAt(GeyserSession session, BlockPositionIterator iter) {
        int[] blocks = new int[iter.getMaxIterations()];
        while (iter.hasNext()) {
            int networkId;
            blocks[iter.getIteration()] = networkId = this.getBlockAt(session, iter.getX(), iter.getY(), iter.getZ());
            iter.next();
        }
        return blocks;
    }

    public abstract boolean hasOwnChunkCache();

    public void setGameRule(GeyserSession session, String name, Object value) {
        session.sendCommand("gamerule " + name + " " + value);
    }

    public abstract boolean getGameRuleBool(GeyserSession var1, GameRule var2);

    public abstract int getGameRuleInt(GeyserSession var1, GameRule var2);

    public void setPlayerGameMode(GeyserSession session, GameMode gameMode) {
        session.sendCommand("gamemode " + gameMode.name().toLowerCase(Locale.ROOT));
    }

    public abstract GameMode getDefaultGameMode(GeyserSession var1);

    public void setDefaultGameMode(GeyserSession session, GameMode gameMode) {
        session.sendCommand("defaultgamemode " + gameMode.name().toLowerCase(Locale.ROOT));
    }

    public void setDifficulty(GeyserSession session, Difficulty difficulty) {
        session.sendCommand("difficulty " + difficulty.name().toLowerCase(Locale.ROOT));
    }

    public abstract boolean hasPermission(GeyserSession var1, String var2);

    public String @Nullable [] getBiomeIdentifiers(boolean withTags) {
        return null;
    }

    public @NonNull CompletableFuture<@Nullable DataComponents> getPickItemComponents(GeyserSession session, int x, int y, int z, boolean addExtraData) {
        return CompletableFuture.completedFuture(null);
    }

    public void getDecoratedPotData(GeyserSession session, Vector3i pos, Consumer<List<String>> apply) {
    }
}

