/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.translator.text.MessageTranslator;

public record JukeboxSong(String soundEvent, String description) {
    public static JukeboxSong read(RegistryEntryContext context) {
        String soundEvent;
        NbtMap data = context.data();
        Object soundEventObject = data.get("sound_event");
        if (soundEventObject instanceof NbtMap) {
            NbtMap map = (NbtMap)soundEventObject;
            soundEvent = map.getString("sound_id");
        } else if (soundEventObject instanceof String) {
            String string;
            soundEvent = string = (String)soundEventObject;
        } else {
            soundEvent = "";
            GeyserImpl.getInstance().getLogger().debug("Sound event for " + context.id() + " was of an unexpected type! Expected string or NBT map, got " + soundEventObject);
        }
        String description = MessageTranslator.deserializeDescription(data);
        return new JukeboxSong(soundEvent, description);
    }
}

