/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.entity.type.living.animal.TropicalFishEntity;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class TropicalFishBucketItem
extends Item {
    private static final Style LORE_STYLE = Style.style((TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC});

    public TropicalFishBucketItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, builder);
        builder.putByte("AppendCustomName", (byte)1);
        builder.putString("CustomName", MinecraftLocale.getLocaleString("entity.minecraft.tropical_fish", session.locale()));
        NbtMap entityTag = components.get(DataComponentType.BUCKET_ENTITY_DATA);
        if (entityTag != null && !entityTag.isEmpty()) {
            int bucketVariant = entityTag.getInt("BucketVariantTag");
            List<String> lore = builder.getOrCreateLore();
            int predefinedVariantId = TropicalFishEntity.getPredefinedId(bucketVariant);
            if (predefinedVariantId != -1) {
                TranslatableComponent tooltip = Component.translatable((String)("entity.minecraft.tropical_fish.predefined." + predefinedVariantId), (Style)LORE_STYLE);
                lore.add(0, MessageTranslator.convertMessage((Component)tooltip, session.locale()));
            } else {
                TranslatableComponent typeTooltip = Component.translatable((String)("entity.minecraft.tropical_fish.type." + TropicalFishEntity.getVariantName(bucketVariant)), (Style)LORE_STYLE);
                lore.add(0, MessageTranslator.convertMessage((Component)typeTooltip, session.locale()));
                byte baseColor = TropicalFishEntity.getBaseColor(bucketVariant);
                byte patternColor = TropicalFishEntity.getPatternColor(bucketVariant);
                TranslatableComponent colorTooltip = Component.translatable((String)("color.minecraft." + TropicalFishEntity.getColorName(baseColor)), (Style)LORE_STYLE);
                if (baseColor != patternColor) {
                    colorTooltip = colorTooltip.append((Component)Component.text((String)", ", (Style)LORE_STYLE)).append((Component)Component.translatable((String)("color.minecraft." + TropicalFishEntity.getColorName(patternColor)), (Style)LORE_STYLE));
                }
                lore.add(1, MessageTranslator.convertMessage((Component)colorTooltip, session.locale()));
            }
        }
    }
}

